/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.data.collective.transformation.VocabularyRegistry;
import eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

public class Convert
extends AbstractTransformationFunction {
    public static final String paramVocabularyName = "vocabularyName";
    public static final String paramFieldValue = "fieldValue";
    public static final String paramDefaultPattern = "defaultPattern";
    public static final String paramFunction = "function";
    @Resource
    private VocabularyRegistry vocabularyRegistry;

    @Override
    public String execute() throws ProcessingException {
        return null;
    }

    public String executeSingleValue(String vocabularyName, List<String> fieldValues) throws ProcessingException {
        if (!this.vocabularyRegistry.getVocabularies().containsKey(vocabularyName)) {
            throw new ProcessingException("unknown vocabulary: " + vocabularyName);
        }
        String returnValue = this.vocabularyRegistry.getVocabulary(vocabularyName).encoding(fieldValues);
        return returnValue;
    }

    public List<String> executeAllValues(String vocabularyName, List<String> fieldValues) throws ProcessingException {
        if (!this.vocabularyRegistry.getVocabularies().containsKey(vocabularyName)) {
            throw new ProcessingException("unknown vocabulary: " + vocabularyName);
        }
        LinkedList<String> computedValues = new LinkedList<String>();
        int numOfComputedValues = fieldValues.size();
        if (numOfComputedValues == 0) {
            numOfComputedValues = 1;
        }
        String returnValue = this.vocabularyRegistry.getVocabulary(vocabularyName).encoding(fieldValues);
        for (int i = 0; i < numOfComputedValues; ++i) {
            computedValues.add(returnValue);
        }
        return computedValues;
    }

    public List<String> executeFilterByParams(String vocabName, List<String> fieldValues, String defaultPattern, String filterFunction) throws ProcessingException {
        return this.vocabularyRegistry.getVocabulary(vocabName).encoding(fieldValues, defaultPattern, filterFunction);
    }

    public VocabularyRegistry getVocabularyRegistry() {
        return this.vocabularyRegistry;
    }

    public void setVocabularyRegistry(VocabularyRegistry vocabularyRegistry) {
        this.vocabularyRegistry = vocabularyRegistry;
    }
}

