/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.utils;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

public class XMLSerializer<T> {
    private Marshaller marshaller;
    private Class<T> clazz;

    public XMLSerializer(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.init();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void init() throws JAXBException {
        Class[] all = new Class[]{this.clazz};
        JAXBContext context = JAXBContext.newInstance((Class[])all);
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)false);
    }

    public String getAsXml(T record) throws JAXBException {
        StringWriter buffer = new StringWriter();
        this.marshaller.marshal(this.createElement(record), (Writer)buffer);
        return buffer.toString();
    }

    protected JAXBElement<T> createElement(T value) {
        XmlRootElement annotation = this.clazz.getAnnotation(XmlRootElement.class);
        return new JAXBElement(new QName(annotation.namespace(), annotation.name()), this.clazz, null, value);
    }
}

