/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine;

import eu.dnetlib.data.collective.transformation.core.xsl.ext.TransformationFunctionProxy;
import eu.dnetlib.data.collective.transformation.engine.FunctionResults;
import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.Extract;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.engine.functions.RegularExpression;
import eu.dnetlib.data.collective.transformation.engine.functions.RetrieveValue;
import eu.dnetlib.data.collective.transformation.rulelanguage.IRule;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class PreProcessor {
    private static final Log log = LogFactory.getLog(PreProcessor.class);
    private Convert convertFunction;
    private Extract extractFunction;
    private RetrieveValue retrieveFunction;
    private RegularExpression regExprFunction;
    private TransformationFunctionProxy functionProxy;
    private SAXReader reader = new SAXReader();
    private Map<String, String> nsMap = new HashMap<String, String>();

    public void preprocess(FunctionCall aFunctionCall, List<String> aObjectRecords, Map<String, String> aNamespaceMap, Map<String, String> aStaticResults, Map<String, String> aJobProperties, Map<String, IRule> aVarRules) {
        this.nsMap = aNamespaceMap;
        FunctionResults functionResults = new FunctionResults();
        try {
            if (aFunctionCall.getExternalFunctionName().equals("extract")) {
                String featureName = aFunctionCall.getParameters().get("feature");
                functionResults.addAll(this.extractFunction.execute(aObjectRecords, featureName));
            } else {
                for (String objRecord : aObjectRecords) {
                    List<String> recordValues;
                    String result = null;
                    if (aFunctionCall.getExternalFunctionName().equals("convert")) {
                        if (aFunctionCall.isStatic() && aStaticResults.containsKey(aFunctionCall.getUuid())) {
                            functionResults.add(aStaticResults.get(aFunctionCall.getUuid()));
                            continue;
                        }
                        String vocabName = aFunctionCall.getParameters().get("vocabularyName");
                        String fieldExpr = aFunctionCall.getParameters().get("fieldValue");
                        recordValues = this.getValuesFromRecord(objRecord, fieldExpr);
                        if (aFunctionCall.isStatic()) {
                            aStaticResults.put(aFunctionCall.getUuid(), this.convertFunction.executeSingleValue(vocabName, recordValues));
                            continue;
                        }
                        functionResults.add(this.convertFunction.executeAllValues(vocabName, recordValues));
                        continue;
                    }
                    if (aFunctionCall.getExternalFunctionName().equals("getValue")) {
                        if (aFunctionCall.isStatic() && aStaticResults.containsKey(aFunctionCall.getUuid())) {
                            functionResults.add(aStaticResults.get(aFunctionCall.getUuid()));
                            continue;
                        }
                        String functionName = aFunctionCall.getParameters().get("functionName");
                        result = this.retrieveFunction.executeSingleValue(functionName, aFunctionCall.getArguments(), objRecord, this.nsMap);
                        functionResults.add(result);
                        if (!aFunctionCall.isStatic()) continue;
                        aStaticResults.put(aFunctionCall.getUuid(), result);
                        continue;
                    }
                    if (!aFunctionCall.getExternalFunctionName().equals("regExpr") || aFunctionCall.isStatic() && aStaticResults.containsKey(aFunctionCall.getUuid())) continue;
                    String regularExpression = aFunctionCall.getParameters().get("regularExpression");
                    String expression1 = aFunctionCall.getParameters().get("expr1");
                    recordValues = null;
                    if (aJobProperties.containsKey(expression1)) {
                        recordValues = new LinkedList<String>();
                        recordValues.add(aJobProperties.get(expression1));
                    } else {
                        recordValues = this.getValuesFromRecord(objRecord, expression1);
                    }
                    String expression2 = aFunctionCall.getParameters().get("expr2");
                    String replacement = "";
                    if (aJobProperties.containsKey(expression2)) {
                        replacement = aJobProperties.get(expression2);
                    } else if (aVarRules.containsKey(expression2)) {
                        Rules varRule = (Rules)aVarRules.get(expression2);
                        replacement = varRule.getConstant().replace("'", "");
                    } else {
                        replacement = this.getValuesFromRecord(objRecord, expression2).get(0);
                    }
                    LinkedList<String> regExprResults = new LinkedList<String>();
                    for (String fieldValue : recordValues) {
                        try {
                            int lastSlash = regularExpression.lastIndexOf("/");
                            String trailingOptions = regularExpression.substring(lastSlash);
                            int replacementSlash = regularExpression.substring(0, lastSlash).lastIndexOf("/");
                            String replacementFromExpression = regularExpression.substring(replacementSlash + 1, lastSlash);
                            String newRegExpr = regularExpression.substring(0, replacementSlash + 1) + replacement + replacementFromExpression + trailingOptions;
                            result = this.regExprFunction.executeSingleValue(newRegExpr, fieldValue, replacement);
                            regExprResults.add(result);
                        }
                        catch (ProcessingException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    functionResults.add(regExprResults);
                    if (!aFunctionCall.isStatic()) continue;
                    aStaticResults.put(aFunctionCall.getUuid(), result);
                }
            }
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
        catch (DocumentException e) {
            throw new IllegalStateException(e);
        }
        this.functionProxy.setResults(aFunctionCall.getUuid(), functionResults);
    }

    public void setFunctionProxy(TransformationFunctionProxy functionProxy) {
        this.functionProxy = functionProxy;
    }

    public TransformationFunctionProxy getFunctionProxy() {
        return this.functionProxy;
    }

    public void setConvertFunction(Convert convertFunction) {
        this.convertFunction = convertFunction;
    }

    public Convert getConvertFunction() {
        return this.convertFunction;
    }

    public void setRetrieveFunction(RetrieveValue retrieveFunction) {
        this.retrieveFunction = retrieveFunction;
    }

    public RetrieveValue getRetrieveFunction() {
        return this.retrieveFunction;
    }

    public RegularExpression getRegExprFunction() {
        return this.regExprFunction;
    }

    public void setRegExprFunction(RegularExpression regExprFunction) {
        this.regExprFunction = regExprFunction;
    }

    public void setExtractFunction(Extract extractFunction) {
        this.extractFunction = extractFunction;
    }

    public Extract getExtractFunction() {
        return this.extractFunction;
    }

    private List<String> getValuesFromRecord(String record, String xpathExpr) throws DocumentException {
        LinkedList<String> values = new LinkedList<String>();
        Document doc = this.reader.read((Reader)new StringReader(record));
        XPath xpath = DocumentHelper.createXPath((String)xpathExpr);
        xpath.setNamespaceURIs(this.nsMap);
        Object context = xpath.evaluate((Object)doc);
        if (context instanceof String) {
            values.add((String)context);
        } else if (context instanceof List) {
            for (Node node : (List)context) {
                values.add(node.getText());
            }
        } else if (context instanceof Node) {
            values.add(((Node)context).getText());
        } else if (context instanceof Number) {
            values.add(((Number)context).intValue() + "");
        }
        return values;
    }
}

