/* Generated By:JJTree: Do not edit this line. ASTMyOp.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=AST,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package eu.dnetlib.data.collective.transformation.rulelanguage.parser;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.Extract;
import eu.dnetlib.data.collective.transformation.engine.functions.IdentifierExtract;
import eu.dnetlib.data.collective.transformation.engine.functions.Lookup;
import eu.dnetlib.data.collective.transformation.engine.functions.RegularExpression;
import eu.dnetlib.data.collective.transformation.engine.functions.Split;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.Converter;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;


/**
 * @author jochen
 *
 */
public class ASTMyOp extends AbstractNode {

	private boolean isFunGetValue = false;
	private boolean isFunConvert = false;
	private boolean isFunConvertString = false;
	private boolean isFunRegExpr = false;
	private boolean isFunExtract = false;
	private boolean isFunSkipRecord = false;
	private boolean isFunSplit = false;
	private boolean isFunLookup = false;
	private boolean isFunConcat = false;
	private boolean isFunIdentifierExtract = false;
	private boolean doPreprocess = true;
	private String functionName = null;

	private Map<String, String> paramMap = null;
	
	private List<Rules> rulesList = new LinkedList<Rules>();
	private List<String> concatList = new LinkedList<String>();

	private String externalFunctionName = null;

	public ASTMyOp(int id) {
		super(id);
	}

	public ASTMyOp(FtScript p, int id) {
		super(p, id);
	}


	/** Accept the visitor. **/
	public Object jjtAccept(FtScriptVisitor visitor, Object data) {
		return visitor.visit(this, data);
	}

	public void getValue(String functionName){
		this.functionName = functionName;
		this.isFunGetValue = true;
		this.externalFunctionName = "getValue";
		paramMap = new LinkedHashMap<String, String>();
		paramMap.put("functionName", functionName);
	}

	public String getFunctionName(){
		return functionName;
	}

	/**
	 * creates a new FunctionCall object
	 * @return a function call object
	 */
	public FunctionCall createFunctionCall(boolean aIsStatic){
		FunctionCall fc = new FunctionCall(aIsStatic, this.doPreprocess);
		fc.setExternalFunctionName(externalFunctionName);
		fc.setParameters(paramMap);
		fc.setParamList(concatList);
		return fc;
	}

	public boolean isGetValue(){
		return isFunGetValue;
	}

	public boolean isConvert(){
		return isFunConvert;
	}
	
	public boolean isConvertString(){
		return isConvertString();
	}

	public boolean isRegExpr(){
		return isFunRegExpr;
	}
	
	public boolean isExtract(){
		return isFunExtract;
	}
	
	public boolean isFunSkipRecord(){
		return isFunSkipRecord;
	}
	
	public boolean isFunSplit(){
		return isFunSplit;
	}
	
	public boolean isLookup(){
		return isFunLookup;
	}
	
	public boolean isConcat(){
		return isFunConcat;
	}

	public void convert(String inputField, String vocabulary, String defaultPattern, String function){
		// evaluate the inputField arg first then decide to apply 'convert' or 'convertString'
		
		String converterInputField = Converter.getXpathFromXpathExpr(inputField);
		if (Converter.isXpathReturningString(converterInputField)){
			this.externalFunctionName = "convertString";
			this.isFunConvertString = true;
		}else{
			this.externalFunctionName = "convert";			
			this.isFunConvert = true;
		}
		this.doPreprocess = false;
		paramMap = new LinkedHashMap<String, String>();
		paramMap.put(Convert.paramFieldValue, converterInputField);
		paramMap.put(Convert.paramVocabularyName, vocabulary);
		if (defaultPattern.trim().length() > 0)
			paramMap.put(Convert.paramDefaultPattern, defaultPattern.substring( (defaultPattern.indexOf("\"") + 1), defaultPattern.lastIndexOf("\"") ));
		if (function.trim().length() > 0)
			paramMap.put(Convert.paramFunction, function.substring( (function.indexOf("\"") + 1), function.lastIndexOf("\"") ));
	}
	
	public void extract(String feature){
		this.isFunExtract = true;
		this.externalFunctionName = "extract";
		paramMap = new LinkedHashMap<String, String>();
		paramMap.put(Extract.paramNameFeature, feature);
	}

	public void regExpr(String inputExpr1, String inputExpr2, String regularExpr){
		this.isFunRegExpr = true;
		this.externalFunctionName = "regExpr";
		this.doPreprocess = false;
		paramMap = new LinkedHashMap<String, String>();
		if (inputExpr1.startsWith("xpath:")){
			paramMap.put(RegularExpression.paramExpr1, Converter.getXpathFromXpathExpr(inputExpr1));			
		}else{
			paramMap.put(RegularExpression.paramExpr1, inputExpr1);			
		}
		if (inputExpr2.startsWith("xpath:")){
			paramMap.put(RegularExpression.paramExpr2, Converter.getXpathFromXpathExpr(inputExpr2));			
		}else{
			paramMap.put(RegularExpression.paramExpr2, inputExpr2);			
		}
		String regExpr = regularExpr.substring( (regularExpr.indexOf("\"") + 1), regularExpr.lastIndexOf("\"") );
		paramMap.put(RegularExpression.paramRegularExpr, regExpr);
	}
	
	public void skipRecord(){
		// TODO
		this.isFunSkipRecord = true;
		this.doPreprocess = false;
		this.externalFunctionName = "skipRecord";
		paramMap = new LinkedHashMap<String, String>();
	}

	public Map<String, String> getParamMap(){
		return paramMap;
	}

	/**
	 * split values of an element into multiple elements
	 * @param inputValue the input value
	 * @param elementName the name of the target element
	 * @param regExpr regular expression (delimiter)
	 */
	public void split(String inputValue, String elementName, String regularExpr) {
		// TODO Auto-generated method stub
		this.isFunSplit = true;
		this.doPreprocess = false;
		this.externalFunctionName = "split";
		paramMap = new LinkedHashMap<String, String>();
		if (inputValue.startsWith("xpath:")){
			paramMap.put(Split.paramInputExpr, Converter.getXpathFromXpathExpr(inputValue));
		}else{
			paramMap.put(Split.paramInputExpr, inputValue);
		}
		String regExpr = regularExpr.substring( (regularExpr.indexOf("\"") + 1), regularExpr.lastIndexOf("\"") );
		paramMap.put(Split.paramRegExpr, regExpr);
		String elemName = elementName.substring( (elementName.indexOf("\"") + 1), elementName.lastIndexOf("\"") );
		paramMap.put(Split.paramElementName, elemName);
	}

	public void addRule(Rules aRule) {
		// TODO Auto-generated method stub
		  rulesList.add(aRule);
		
	}

	/**
	 * set parameters for the dblookup function
	 * @param aSqlExpr
	 */
	public void lookup(String aExprId, String aExprProperty) {
		this.isFunLookup = true;
		this.doPreprocess = false;
		this.externalFunctionName = "lookup";
		paramMap = new LinkedHashMap<String, String>();
		if (aExprId.startsWith("xpath:")){
			paramMap.put(Lookup.paramExprIdentifier, Converter.getXpathFromXpathExpr(aExprId));
		}else{
			paramMap.put(Lookup.paramExprIdentifier, aExprId);			
		}
		// unquote
		String exprProperty;
		if (aExprProperty.length() > 0){
			exprProperty = aExprProperty.substring(1, aExprProperty.length() - 1);			
			paramMap.put(Lookup.paramExprProperty, exprProperty);
		}
	}

	public void concat(){
		this.isFunConcat = true;
		this.doPreprocess = true;
		this.externalFunctionName = "concat";		
	}
	
	public void addConcat(String aTerm) {
		concatList.add(aTerm);
	}

	public void identifierExtract(String aXpathExprJsonString, String aXpathExprInSource,
			String aRegExpr) {
		this.isFunIdentifierExtract = true;
		this.doPreprocess = false;
		this.externalFunctionName = "identifierExtract";
		paramMap = new LinkedHashMap<String, String>();
		if (aXpathExprInSource.startsWith("xpath:")) paramMap.put(IdentifierExtract.paramXpathExprInSource, Converter.getXpathFromXpathExpr(aXpathExprInSource));
		else paramMap.put(IdentifierExtract.paramXpathExprInSource, aXpathExprInSource);
//		List<String> xpathExprList = JSONParser.defaultJSONParser().parse(List.class, aXpathExprJsonString);
		paramMap.put(IdentifierExtract.paramXpathExprJson, Converter.getUnquotedString(aXpathExprJsonString));
		paramMap.put(IdentifierExtract.paramRegExpr, Converter.getUnquotedString(aRegExpr));
	}

	/**
	 * @return the isFunIdentifierExtract
	 */
	public boolean isFunIdentifierExtract() {
		return isFunIdentifierExtract;
	}

}
/* JavaCC - OriginalChecksum=3d515ff3345fb356c3993ac1bf1d77cc (do not edit this line) */
