/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine;

import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.IDatabaseConnector;
import eu.dnetlib.data.collective.transformation.TransformationException;
import eu.dnetlib.data.collective.transformation.VocabularyRegistry;
import eu.dnetlib.data.collective.transformation.core.xsl.ext.TransformationFunctionProxy;
import eu.dnetlib.data.collective.transformation.engine.PreProcessor;
import eu.dnetlib.data.collective.transformation.engine.core.ITransformation;
import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.Dblookup;
import eu.dnetlib.data.collective.transformation.engine.functions.Extract;
import eu.dnetlib.data.collective.transformation.engine.functions.IFeatureExtraction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.engine.functions.RegularExpression;
import eu.dnetlib.data.collective.transformation.engine.functions.RetrieveValue;
import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SimpleTransformationEngine {
    private static Log log = LogFactory.getLog(SimpleTransformationEngine.class);
    private ITransformation transformation;
    private VocabularyRegistry vocabularyRegistry;
    private IDatabaseConnector databaseConnector;
    private ResourceDao resourceDao;
    private IFeatureExtraction featureExtraction;
    private final List<String> ignoreRecords = new LinkedList<String>();
    private final List<String> mdRecords = new LinkedList<String>();
    private long totalTransformedRecords = 0L;
    private long totalIgnoredRecords = 0L;
    private String mappingFile;
    private boolean stylesheetParamsCalculated = false;
    private Map<String, String> stylesheetParams = new LinkedHashMap<String, String>();

    public void preprocess() {
        for (Map<String, String> preprocMap : this.transformation.getRuleLanguageParser().getPreprocessings()) {
            for (String function : preprocMap.keySet()) {
                if (!function.equals("dblookup")) continue;
                Dblookup fun = new Dblookup();
                fun.setDbConnector(this.databaseConnector);
                try {
                    log.debug((Object)("preprocessingMap value: " + preprocMap.get(function)));
                    TransformationFunctionProxy.getInstance().setLookupRecord(fun.getResults(preprocMap.get(function)));
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
        }
        log.debug((Object)"preprocessing done.");
    }

    public String transform(String sourceRecord) {
        LinkedList<String> objectRecords = new LinkedList<String>();
        objectRecords.add(sourceRecord);
        int index = 0;
        this.mdRecords.clear();
        this.ignoreRecords.clear();
        this.initTransformationFunction();
        TransformationFunctionProxy.getInstance().setIgnoreRecordList(this.ignoreRecords);
        if (!this.transformation.getRuleLanguageParser().isXslStylesheet()) {
            log.debug((Object)("functionCalls size: " + this.transformation.getRuleLanguageParser().getFunctionCalls().size()));
            for (FunctionCall functionCall : this.transformation.getRuleLanguageParser().getFunctionCalls()) {
                this.preprocess(objectRecords, functionCall);
            }
            for (String record : objectRecords) {
                try {
                    log.debug((Object)("now run transformation for record with index: " + index));
                    String transformedRecord = this.transformation.transformRecord(record, index);
                    if (!this.ignoreRecords.contains("" + index)) {
                        this.mdRecords.add(transformedRecord);
                    } else {
                        this.mdRecords.add(this.transformation.transformRecord(record, "syntaxcheckfailed.xsl"));
                    }
                }
                catch (TransformationException e) {
                    log.error((Object)sourceRecord);
                    throw new IllegalStateException(e);
                }
                ++index;
            }
        } else {
            for (String record : objectRecords) {
                try {
                    if (!this.stylesheetParamsCalculated) {
                        this.calculateStylesheetParams(record);
                    }
                    log.debug((Object)("now run transformation for record with index: " + index));
                    String transformedRecord = this.transformation.transformRecord(record, this.stylesheetParams);
                    if (!this.ignoreRecords.contains("" + index)) {
                        this.mdRecords.add(transformedRecord);
                    } else {
                        this.mdRecords.add(this.transformation.transformRecord(record, "syntaxcheckfailed.xsl"));
                    }
                }
                catch (TransformationException e) {
                    log.error((Object)sourceRecord);
                    throw new IllegalStateException(e);
                }
                catch (XPathExpressionException e) {
                    log.fatal((Object)"couldn't calculate stylesheet params");
                    throw new IllegalStateException(e);
                }
                catch (ProcessingException e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        this.totalTransformedRecords += (long)this.mdRecords.size();
        this.totalIgnoredRecords += (long)this.ignoreRecords.size();
        log.debug((Object)("objRecordSize: " + objectRecords.size() + ", mdRecordSize: " + this.mdRecords.size() + ", ignoredRecordSize: " + this.ignoreRecords.size()));
        return this.mdRecords.get(0);
    }

    private void calculateStylesheetParams(String aRecord) throws XPathExpressionException, ProcessingException {
        this.stylesheetParamsCalculated = true;
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node root = (Node)xpath.evaluate("/", new InputSource(new StringReader(aRecord)), XPathConstants.NODE);
        String repositoryId = xpath.evaluate("//*[local-name()='repositoryId']", root);
        log.debug((Object)("repositoryId: " + repositoryId));
        RetrieveValue retrieveValue = new RetrieveValue();
        retrieveValue.setResourceDao(this.resourceDao);
        LinkedList<Argument> argList = new LinkedList<Argument>();
        argList.add(new Argument(Argument.Type.VALUE, repositoryId));
        Argument argXpath = new Argument(Argument.Type.INPUTFIELD, "//OFFICIAL_NAME");
        argList.add(argXpath);
        String varOfficialName = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varOfficialName", varOfficialName);
        argList.remove(argXpath);
        argXpath = new Argument(Argument.Type.INPUTFIELD, "//EXTRA_FIELDS/FIELD[key='OpenAireDataSourceId']/value");
        argList.add(argXpath);
        String varDataSourceId = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varDataSourceId", varDataSourceId);
        argList.remove(argXpath);
        argXpath = new Argument(Argument.Type.INPUTFIELD, "//CONFIGURATION/DATASOURCE_TYPE");
        argList.add(argXpath);
        String varDsType = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varDsType", varDsType);
    }

    private void initTransformationFunction() {
        if (this.vocabularyRegistry == null) {
            throw new IllegalStateException("vocabularyReg is null");
        }
        Convert convertFunction = new Convert();
        convertFunction.setVocabularyRegistry(this.vocabularyRegistry);
        TransformationFunctionProxy.getInstance().setConvertFunction(convertFunction);
    }

    private void preprocess(List<String> records, FunctionCall aFunctionCall) {
        try {
            log.debug((Object)"preprocess");
            if (this.transformation.getRuleLanguageParser() == null) {
                throw new IllegalStateException("rulelanguageparser not initialised");
            }
            if (this.transformation.getRuleLanguageParser().getNamespaceDeclarations() == null) {
                throw new IllegalStateException("nsDecl is null");
            }
            PreProcessor preProc = new PreProcessor();
            preProc.setConvertFunction(TransformationFunctionProxy.getInstance().getConvertFunction());
            RetrieveValue retrieveValue = new RetrieveValue();
            retrieveValue.setResourceDao(this.resourceDao);
            preProc.setRetrieveFunction(retrieveValue);
            RegularExpression regExpr = new RegularExpression();
            preProc.setRegExprFunction(regExpr);
            TransformationFunctionProxy functionProxy = TransformationFunctionProxy.getInstance();
            preProc.setFunctionProxy(functionProxy);
            Extract extractFunction = new Extract();
            extractFunction.setFeatureExtraction(this.featureExtraction);
            preProc.setExtractFunction(extractFunction);
            if (aFunctionCall.doPreprocess() || aFunctionCall.isStatic()) {
                preProc.preprocess(aFunctionCall, records, this.transformation.getRuleLanguageParser().getNamespaceDeclarations(), this.transformation.getStaticTransformationResults(), this.transformation.getJobProperties(), this.transformation.getRuleLanguageParser().getVariableMappingRules());
            } else {
                log.debug((Object)("skip preprocessing for function: " + aFunctionCall.getExternalFunctionName()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setTransformation(ITransformation transformation) {
        this.transformation = transformation;
    }

    public ITransformation getTransformation() {
        return this.transformation;
    }

    public void setVocabularyRegistry(VocabularyRegistry vocabularyRegistry) {
        this.vocabularyRegistry = vocabularyRegistry;
    }

    public VocabularyRegistry getVocabularyRegistry() {
        return this.vocabularyRegistry;
    }

    public ResourceDao getResourceDao() {
        return this.resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public void setFeatureExtraction(IFeatureExtraction featureExtraction) {
        this.featureExtraction = featureExtraction;
    }

    public IFeatureExtraction getFeatureExtraction() {
        return this.featureExtraction;
    }

    public IDatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }

    public void setDatabaseConnector(IDatabaseConnector databaseConnector) {
        this.databaseConnector = databaseConnector;
    }

    public long getTotalTransformedRecords() {
        return this.totalTransformedRecords;
    }

    public long getTotalIgnoredRecords() {
        return this.totalIgnoredRecords;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }
}

