package eu.dnetlib.clients.data.publisher.ws;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;

import org.apache.log4j.Logger;

import eu.dnetlib.api.data.PublisherService;
import eu.dnetlib.utils.resolver.ServiceClientFactory;

public class PublisherWSClientFactory implements
		ServiceClientFactory<PublisherService> {
	private CacheManager cacheManager = null;

	private final String cacheName = "publisherCache";

	@Override
	public PublisherService newClient(Object endpoint) {
		Ehcache cache = cacheManager.getEhcache(cacheName);
		PublisherWSClient client = new PublisherWSClient();

		if (cache == null) {
			cacheManager.addCache(cacheName);
		}

		cache = new SelfPopulatingCache(
				cacheManager.getEhcache(cacheName),
				new PublisherServiceEntryFactory(
						(eu.dnetlib.data.information.publisher.rmi.PublisherService) endpoint));

		client.setClient((eu.dnetlib.data.information.publisher.rmi.PublisherService) endpoint);
		client.setDocumentCache(cache);

		return client;
	}

	public CacheManager getCacheManager() {
		return cacheManager;
	}

	public void setCacheManager(CacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}

	class PublisherServiceEntryFactory implements CacheEntryFactory {
		private eu.dnetlib.data.information.publisher.rmi.PublisherService client = null;
		private Logger logger = Logger.getLogger(PublisherServiceEntryFactory.class);

		public PublisherServiceEntryFactory(
				eu.dnetlib.data.information.publisher.rmi.PublisherService client) {
			this.client = client;
		}

		public Object createEntry(Object o) {
			throw new UnsupportedOperationException();
//			String[] args = ((String) o).split("@");
//
//			if (logger.isDebugEnabled()) {
//				logger.debug("Document with id " + args[0] + "not found "
//						+ " in cache. Querying publisher service");
//				logger.debug("id: " + args[0]);
//				logger.debug("format:" + args[1]);
//			}
//
//			return client.getResourceById(args[0], args[1]);
		}
	}
}