package eu.dnetlib.clients.data.dataaccess.ws;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.DataAccessService;
import eu.dnetlib.api.data.DataAccessServiceException;
import eu.dnetlib.data.sts.das.IDataAccessService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.utils.ServiceIdentityFactory;

public class DataAccessServiceWSClient implements DataAccessService {
	private IDataAccessService service = null;
	
	public void setWebService(Object endpoint) {
		this.service = (IDataAccessService) endpoint;
	}

	@Override
	public String getObjectSDO(String storeId, String objectId)
			throws DataAccessServiceException {
		try {
			return service.getObjectSDO(objectId, storeId);
		} catch (eu.dnetlib.data.sts.das.DataAccessServiceException e) {
			throw new DataAccessServiceException("Error getting object SDO", e);
		}
	}

	@Override
	public String getObjectUrl(String storeId, String objectId)
			throws DataAccessServiceException {
		try {
			return service.getObjectUrl(objectId, storeId);
		} catch (eu.dnetlib.data.sts.das.DataAccessServiceException e) {
			throw new DataAccessServiceException("Error getting object Url", e);
		}
	}

	@Override
	public EPR storeLookUpDataRS(String storeId)
			throws DataAccessServiceException {
		try {
			W3CEndpointReference w3cEpr = service.storeLookUpDataRS(storeId);
			
			return EPRUtils.createEPR(w3cEpr);
		} catch (eu.dnetlib.data.sts.das.DataAccessServiceException e) {
			throw new DataAccessServiceException("Error searching store", e);
		}
	}

	@Override
	public EPR storeLookUpRS(String storeId) throws DataAccessServiceException {
		try {
			W3CEndpointReference w3cEpr = service.storeLookUpRS(storeId);
			
			return EPRUtils.createEPR(w3cEpr);
		} catch (eu.dnetlib.data.sts.das.DataAccessServiceException e) {
			throw new DataAccessServiceException("Error searching store", e);
		}
	}

	@Override
	public EPR storeLookUpSDORS(String storeId)
			throws DataAccessServiceException {
		try {
			W3CEndpointReference w3cEpr = service.storeLookUpSDORS(storeId);
			
			return EPRUtils.createEPR(w3cEpr);
		} catch (eu.dnetlib.data.sts.das.DataAccessServiceException e) {
			throw new DataAccessServiceException("Error searching store", e);
		}
	}

	@Override
	public ServiceIdentity identify() {
		return ServiceIdentityFactory.parseIdentity(service.identify());
	}

	@Override
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();
	}
}
