package eu.dnetlib.clients.data.datasourcemanager.ws;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;

public class Converter {
	
	private static Logger logger = Logger.getLogger(Converter.class);

	/**
	 * @param args
	 * @return 
	 * 
	 */
	
	public static Repository convertToValRepo(DatasourceDesc from) {
		logger.debug("Converting the repository to Validator format");
		Repository repo = new Repository();
		repo.setId(from.getId());
		repo.setOfficialName(from.getOfficialName());
		repo.setEnglishName(from.getEnglishName());
		repo.setWebsiteUrl(from.getWebsiteUrl());
		repo.setLogoUrl(from.getLogoUrl());
		repo.setContactEmail(from.getContactEmail());
		repo.setCountryName(from.getCountryName());
		repo.setCountryCode(from.getCountryCode());
		repo.setOrganization(from.getOrganization());
		repo.setLatitude(from.getLatitude());
		repo.setLongitude(from.getLongitude());
		repo.setTimezone(from.getTimezone());
		repo.setNamespacePrefix(from.getNamespacePrefix());
		repo.setOdNumberOfItems(from.getOdNumberOfItems());
		repo.setOdNumberOfItemsDate(from.getOdNumberOfItemsDate());
		repo.setOdPolicies(from.getOdPolicies());
		repo.setOdLanguages(from.getOdLanguages());
		repo.setOdContentTypes(from.getOdContentTypes());
		repo.setCollectedFrom(from.getCollectedFrom());
		repo.setInferred(from.isInferred());
		repo.setDeletedByInference(from.isDeletedByInference());
		repo.setTrust(from.getTrust());
		repo.setTrust(0.9);
		repo.setInferenceProvenance(from.getInferenceProvenance());
		repo.setDateOfValidation(from.getDateOfValidation());
		repo.setDatasourceClass(from.getDatasourceClass());
		repo.setProvenanceActionClass(from.getProvenanceActionClass());
		repo.setDateOfCollection(from.getDateOfCollection());
		repo.setTypology(from.getTypology());
		repo.setActivationId(from.getActivationId());
		repo.setMergehomonyms(from.isMergehomonyms());
		repo.setDescription(from.getDescription());
		repo.setReleaseStartDate(from.getReleaseStartDate());
		repo.setReleaseEndDate(from.getReleaseEndDate());
		repo.setMissionStatementUrl(from.getMissionStatementUrl());
		repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
		repo.setDataProvider(from.isDataProvider());
		repo.setServiceProvider(from.isServiceProvider());
		repo.setDatabaseAccessType(from.getDatabaseAccessType());
		repo.setDataUploadType(from.getDataUploadType());
		repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
		repo.setDataUploadRestriction(from.getDataUploadRestriction());
		repo.setVersioning(from.isVersioning());
		repo.setCitationGuidelineUrl(from.getCitationGuidelineUrl());
		repo.setQualityManagementKind(from.getQualityManagementKind());
		repo.setPidSystems(from.getPidSystems());
		repo.setCertificates(from.getCertificates());
		repo.setAggregator(from.getAggregator());
		repo.setIssn(from.getIssn());
		repo.setEissn(from.getEissn());
		repo.setLissn(from.getLissn());
		repo.setRegisteredBy(from.getRegisteredBy());
		
		repo.setInterfaces(convertToValIfaceList(from.getInterfaces()));

		return repo;
	}
	
	public static DatasourceDesc convertToDsmRepo(Repository from) {
		logger.debug("Converting the repository to Dsm format");
		DatasourceDesc repo = new DatasourceDesc();
		repo.setId(from.getId());
		repo.setOfficialName(from.getOfficialName());
		repo.setEnglishName(from.getEnglishName());
		repo.setWebsiteUrl(from.getWebsiteUrl());
		repo.setLogoUrl(from.getLogoUrl());
		repo.setContactEmail(from.getContactEmail());
		repo.setCountryName(from.getCountryName());
		repo.setCountryCode(from.getCountryCode());
		repo.setOrganization(from.getOrganization());
		repo.setLatitude(from.getLatitude());
		repo.setLongitude(from.getLongitude());
		repo.setTimezone(from.getTimezone());
		repo.setNamespacePrefix(from.getNamespacePrefix());
		repo.setOdNumberOfItems(from.getOdNumberOfItems());
		repo.setOdNumberOfItemsDate(from.getOdNumberOfItemsDate());
		repo.setOdPolicies(from.getOdPolicies());
		repo.setOdLanguages(from.getOdLanguages());
		repo.setOdContentTypes(from.getOdContentTypes());
		repo.setCollectedFrom(from.getCollectedFrom());
		repo.setInferred(from.getInferred());
		repo.setInferred(false);
		repo.setDeletedByInference(from.getDeletedByInference());
		repo.setDeletedByInference(false);
		repo.setTrust(from.getTrust());
		repo.setTrust(0.9);
		repo.setInferenceProvenance(from.getInferenceProvenance());
		repo.setDateOfValidation(from.getDateOfValidation());
		repo.setDatasourceClass(from.getDatasourceClass());
		repo.setProvenanceActionClass(from.getProvenanceActionClass());
		repo.setDateOfCollection(from.getDateOfCollection());
		repo.setTypology(from.getTypology());
		repo.setActivationId(from.getActivationId());
		repo.setMergehomonyms(from.getMergehomonyms());
		repo.setMergehomonyms(true);
		repo.setDescription(from.getDescription());
		repo.setReleaseStartDate(from.getReleaseStartDate());
		repo.setReleaseEndDate(from.getReleaseEndDate());
		repo.setMissionStatementUrl(from.getMissionStatementUrl());
		repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
		repo.setDataProvider(from.getDataProvider());
		repo.setDataProvider(false);
		repo.setServiceProvider(from.getServiceProvider());
		repo.setServiceProvider(false);
		repo.setDatabaseAccessType(from.getDatabaseAccessType());
		repo.setDataUploadType(from.getDataUploadType());
		repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
		repo.setDataUploadRestriction(from.getDataUploadRestriction());
		repo.setVersioning(from.getVersioning());
		repo.setVersioning(false);
		repo.setCitationGuidelineUrl(from.getCitationGuidelineUrl());
		repo.setQualityManagementKind(from.getQualityManagementKind());
		repo.setPidSystems(from.getPidSystems());
		repo.setCertificates(from.getCertificates());
		repo.setAggregator(from.getAggregator());
		repo.setIssn(from.getIssn());
		repo.setEissn(from.getEissn());
		repo.setLissn(from.getLissn());
		repo.setRegisteredBy(from.getRegisteredBy());
		
		repo.setInterfaces(convertToDsmIfaceList(from.getInterfaces()));

		return repo;
	}
	
	public static RepositoryInterface convertToValIface(IfaceDesc from) {
		logger.debug("Converting the interface to Validator format");
		RepositoryInterface newIface = new RepositoryInterface();
		if (from == null) {
			logger.debug("iface 'from' iss null!!" );
		} else {
			
		if (from.getId() == null) {
			logger.debug("iface ID is null " );
		} else {
			logger.debug("iface ID: " + from.getId());
		}
		newIface.setId(from.getId());
		newIface.setTypology(from.getTypology());
		newIface.setCompliance(from.getCompliance());
		newIface.setBaseUrl(from.getBaseUrl());
		newIface.setAccessProtocol(from.getAccessProtocol());
		newIface.setActive(from.getActive());
		newIface.setContentDescription(from.getContentDescription());
		newIface.setRemovable(from.getRemovable());
		newIface.setExtraFields(from.getExtraFields());
		newIface.setAccessParams(from.getAccessParams());
		}		
		return newIface;
		
	}
	
	public static IfaceDesc convertToDsmIface(RepositoryInterface from) {
		logger.debug("Converting the interface to Dsm format");
		IfaceDesc newIface = new IfaceDesc();
		try {
		newIface.setId(from.getId());
		newIface.setTypology(from.getTypology());
		newIface.setCompliance(from.getCompliance());
		newIface.setBaseUrl(from.getBaseUrl());
		newIface.setAccessProtocol(from.getAccessProtocol());
		newIface.setActive(from.isActive());
		newIface.setContentDescription(from.getContentDescription());
		newIface.setRemovable(from.isRemovable());
		newIface.setExtraFields(from.getExtraFields());
		newIface.setAccessParams(from.getAccessParams());
		
//		logger.error("api_id: " + newIface.getId());
//		logger.error("baseUrl: " + newIface.getBaseUrl());
//		logger.error("format: " + newIface.getAccessParams().get("FORMAT"));
//		logger.error("set: " + newIface.getAccessParams().get("SET"));
//		logger.error("typology: " + newIface.getTypology());
//		logger.error("compliance: " + newIface.getCompliance());
//		logger.error("protocol: " + newIface.getAccessProtocol());
//		logger.error("description: " + newIface.getContentDescription());
//		logger.error("removable: " + newIface.getRemovable());
//		logger.error("active: " + newIface.getActive());
		} catch (Exception e) {
			logger.error("Converting the interface to Dsm format " + e);
		}
		return newIface;
		
	}	
	
	public static List<RepositoryInterface> convertToValIfaceList(List<IfaceDesc> fromList) {
		logger.debug("Converting the interfaces to Validation format");
		logger.debug("Number of interfaces to be converted: " + fromList.size());
		List<RepositoryInterface> interfaces = new ArrayList<RepositoryInterface>();
		for (IfaceDesc from : fromList) {
			if (from == null) {
				logger.debug("iface is null: ");
			}
			interfaces.add(convertToValIface(from));
		}
		return interfaces;
	}
	
	public static List<IfaceDesc> convertToDsmIfaceList(List<RepositoryInterface> fromList) {
		logger.debug("Converting the interfaces to dsm format");
		logger.debug("Number of interfaces to be converted: " + fromList.size());
		List<IfaceDesc> interfaces = new ArrayList<IfaceDesc>();
		for (RepositoryInterface from : fromList) {
			interfaces.add(convertToDsmIface(from));
		}
		
		return interfaces;
	}
	
	public static List<Repository> convertToValRepoList(List<DatasourceDesc> fromList) {
		logger.debug("Converting the repositories to Validation format");
		logger.debug("Number of repositories to be converted: " + fromList.size());
		List<Repository> retList = new ArrayList<Repository>();
		for (DatasourceDesc from : fromList) {
			retList.add(convertToValRepo(from));
		}
		return retList;
	}
	
	public static List<DatasourceDesc> convertToDsmRepoList(List<Repository> fromList) {
		logger.debug("Converting the repositories to Dsm format");
		logger.debug("Number of repositories to be converted: " + fromList.size());
		List<DatasourceDesc> retList = new ArrayList<DatasourceDesc>();
		for (Repository from : fromList) {
			retList.add(convertToDsmRepo(from));
		}
		return retList;
	}
	
	
}
