package eu.dnetlib.clients.functionality.forum.ws;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.api.functionality.ForumService;
import eu.dnetlib.api.functionality.ForumServiceException;
import eu.dnetlib.clients.ws.DriverWebService;
import eu.dnetlib.domain.functionality.Post;
import eu.dnetlib.domain.functionality.Thread;

/**
 * This interface describes the available methods  of a forum web service.
 * @author thanos@di.uoa.gr
 *
 */
@WebService
public interface ForumWebService extends DriverWebService<ForumService> {
	/**
	 * Open a new thread.
	 * @param communityId the id of the community that the thread belongs to
	 * @param userId the id of the user that opens the thread
	 * @param topic the topic of the thread
	 * @return the id of the thread just opened
	 * @throws ForumServiceException if any errors occur
	 */
	@WebMethod(operationName = "openThread")
	public long openThread(
			@WebParam(name = "communityId") String communityId,
			@WebParam(name = "userId") String userId,
			@WebParam(name = "topic") String topic
			) throws ForumWebServiceException;
	
	/**
	 * Edit an existing thread.
	 * @param threadId the id of the thread to edit
	 * @param topic the new topic of the thread
	 * @throws ForumServiceException if any errors occur
	 */
	@WebMethod(operationName = "editThread")
	public void editThread(
			@WebParam(name = "threadId") long threadId,
			@WebParam(name = "topic") String topic,
			@WebParam(name = "posts") List<Post> posts
		) throws ForumWebServiceException;
	
	/**
	 * Delete an existing thread.
	 * @param threadId the id of the thread to delete
	 * @throws ForumServiceException if any errors occur
	 */
	@WebMethod(operationName = "deleteThread")
	public void deleteThread(
			@WebParam(name = "threadId") long threadId
			) throws ForumWebServiceException;
	
	/**
	 * Search for an existing thread by id.
	 * @param threadId the id of the thread to search for
	 * @return the thread with the specified id or null if no such thread exists
	 * @throws ForumServiceException if any errors occur
	 */
	@WebMethod(operationName = "searchThreadById")
	public Thread searchThread(
			@WebParam(name = "threadId") long threadId
			) throws ForumWebServiceException;
	
	/**
	 * Search for existing threads by community.
	 * @param communityId the id of the community the threads belong to
	 * @return a list containing all the threads that belong to the specified community
	 * @throws ForumServiceException if any errors occur
	 */
	@WebMethod(operationName = "searchThreadByCommunity")
	public List<Thread> searchThread(
			@WebParam(name = "communityId") String communityId
			) throws ForumWebServiceException;
}
