package eu.dnetlib.clients.functionality.validator.ws;

import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.utils.EPRUtils;

@WebService(
		targetNamespace ="http://services.dnetlib.eu/",
		serviceName = "ValidatorWebService", 
		endpointInterface = "eu.dnetlib.clients.functionality.validator.ws.ValidatorWebService")
public class ValidatorWebServiceImpl
		extends BaseDriverWebService<ValidatorService>
		implements ValidatorWebService {

	@Override
	public W3CEndpointReference validate(W3CEndpointReference datasource) {
		EPR input = EPRUtils.createEPR(datasource);
		
		return EPRUtils.createW3CEPR(service.validate(input));
	}

}
