package eu.dnetlib.clients.data.datasourcemanager.ws;

import java.util.Date;
import java.util.List;

import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.domain.enabling.Notification;

public class DatasourceManagerServiceClient implements DatasourceManagerService {
	
	private static Logger logger = Logger.getLogger(DatasourceManagerServiceClient.class);
	
	private eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService client = null;
	
	public DatasourceManagerServiceClient() throws JAXBException {
	}
	
	public void setClient(eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService client) {
		this.client = client;
	}	
	
	public eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService getClient() {
		return client;
	}
	
	public void setWebService(Object webService) {
		this.client = (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService) webService;
	}

	@Override
	public boolean addDatasource(Repository repository)
			throws DatasourceManagerServiceException {
		logger.debug("Adding datasource");
		try {
			client.addDatasource(Converter.convertToDsmRepo(repository));
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error adding datasource" + e);
		}
		return false;
	}

	@Override
	public boolean deleteDatasource(String dsId)
			throws DatasourceManagerServiceException {
		logger.debug("deleting datasource");
		try {
			client.deleteDatasource(dsId);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error deleting datasource" + e);
		}
		return false;
	}

	@Override
	public Repository getDatasource(String dsId)
			throws DatasourceManagerServiceException {
		logger.debug("getting datasource");
		Repository retRepo = null;
		try {
			retRepo = Converter.convertToValRepo(client.getDatasource(dsId));
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error getting datasource" + e);
		}
		return retRepo;
	}

	@Override
	public List<Repository> listAllDatasources()
			throws DatasourceManagerServiceException {
		logger.debug("getting datasource list");
		List<Repository> retList = null;
		try {
			retList = Converter.convertToValRepoList(client.listAllDatasources());
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error getting datasource list" + e);
		}
		return retList;
	}

	@Override
	public List<Repository> listDatasourcesUsingFilter(String compliance,
			String contentDescription, String iisProcessingWorkflow, String collectedFrom)
			throws DatasourceManagerServiceException {
		logger.debug("getting datasource list using filters");
		List<Repository> retList = null;
		try {
			retList = Converter.convertToValRepoList(client.listDatasourcesUsingFilter(compliance, contentDescription, iisProcessingWorkflow, collectedFrom));
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error getting datasource list using filters" + e);
		}
		return retList;
	}

	@Override
	public boolean updateLevelOfCompliance(String dsId, String ifaceId,
			String level) throws DatasourceManagerServiceException {
		logger.debug("updating level of compliance");
		Boolean ret = false;
		try {
			ret = client.updateLevelOfCompliance(dsId, ifaceId, level);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating level of compliance" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateBaseUrl(String dsId, String ifaceId, String baseUrl)
			throws DatasourceManagerServiceException {
		logger.debug("updating baseurl");
		Boolean ret = false;
		try {
			ret = client.updateBaseUrl(dsId, ifaceId, baseUrl);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating baseurl" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateActivationStatus(String dsId, String ifaceId,
			boolean active) throws DatasourceManagerServiceException {
		logger.debug("updating activation status");
		Boolean ret = false;
		try {
			ret = client.updateActivationStatus(dsId, ifaceId, active);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating activation status" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateContentDescription(String dsId, String ifaceId,
			String desc) throws DatasourceManagerServiceException {
		logger.debug("updating content description");
		Boolean ret = false;
		try {
			ret = client.updateContentDescription(dsId, ifaceId, desc);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating content description" + e);
		}
		
		return ret;
	}

	@Override
	public boolean setIisProcessingWorkflow(String dsId, String ifaceId,
			String wf) throws DatasourceManagerServiceException {
		logger.debug("setting processing workflow");
		Boolean ret = false;
		try {
			ret = client.setIisProcessingWorkflow(dsId, ifaceId, wf);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error setting processing workflow" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateExtraField(String dsId, String ifaceId, String field,
			String value, boolean preserveOriginal)
			throws DatasourceManagerServiceException {
		logger.debug("updating extra field");
		Boolean ret = false;
		try {
			ret = client.updateExtraField(dsId, ifaceId, field, value, preserveOriginal);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating extra field" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateAccessParam(String dsId, String ifaceId, String field,
			String value, boolean preserveOriginal)
			throws DatasourceManagerServiceException {
		logger.debug("updating access param");
		Boolean ret = false;
		try {
			ret = client.updateAccessParam(dsId, ifaceId, field, value, preserveOriginal);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating access param" + e);
		}
		
		return ret;
	}

	@Override
	public boolean deleteAccessParamOrExtraField(String dsId, String ifaceId,
			String field) throws DatasourceManagerServiceException {
		logger.debug("deleting access param or extra field");
		Boolean ret = false;
		try {
			ret = client.deleteAccessParamOrExtraField(dsId, ifaceId, field);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error deleting access param or extra field" + e);
		}
		
		return ret;
	}

	@Override
	public boolean addInterface(String dsId, RepositoryInterface iface)
			throws DatasourceManagerServiceException {
		logger.debug("adding interface");
		Boolean ret = false;
		try {
			ret = client.addInterface(dsId, Converter.convertToDsmIface(iface));
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error adding interface" + e);
		}
		
		return ret;
	}

	@Override
	public boolean deleteInterface(String dsId, String ifaceId)
			throws DatasourceManagerServiceException {
		logger.debug("deleting interface");
		Boolean ret = false;
		try {
			ret = client.deleteInterface(dsId, ifaceId);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error deleting interface" + e);
		}
		
		return ret;
	}

	@Override
	public boolean updateSQL(String dsId, String sql, boolean delete)
			throws DatasourceManagerServiceException {
		logger.debug("updating sql");
		Boolean ret = false;
		try {
			ret = client.updateSQL(dsId, sql, delete);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.error("Error updating sql" + e);
		}
		
		return ret;
	}
	
	@Override
	public Date findNextScheduledExecution(String dsId, String ifaceId)
					throws DatasourceManagerServiceException {
		logger.debug("finding next scheduled job");
		Date ret = null;
		try {
			ret=client.findNextScheduledExecution(dsId, ifaceId);
		} catch (eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException e) {
			logger.debug("error finding next scheduled job");
		}
		return ret;
	}

	@Override
	public ServiceIdentity identify() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();		
	}


}
