package eu.dnetlib.clients.utils.ws;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import gr.uoa.di.driver.util.ServiceLocator;

/**
 * This is an implementation of the service locator that uses a CNR service
 * locator. The CNR service locator returns endpoints to services, so the job of
 * this locator is to use the CNR locator to get service endpoint and use a
 * ServiceClientFactory to create a client for this endpoint.
 * 
 * It holds no cache of the located service. Any subsequent call to getService()
 * will produce a new client. It is up to the caller to cache and refresh the
 * result.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 * 
 * @param <S>
 */
public class CompatibilityServiceLocator<S extends DriverService> implements
		ServiceLocator<S> {

	private static Logger logger = Logger
			.getLogger(CompatibilityServiceLocator.class);

	/**
	 * The CNR service locator. It is not bounded because the endpoints do not
	 * follow the DriverWebService hierarchy.
	 */
	private eu.dnetlib.enabling.tools.ServiceLocator<?> serviceLocator = null;

	/** The service class */
	private Class<S> serviceClass = null;

	/** The factory used to create service clients */
	private ServiceClientFactory<S> clientFactory = null;

	@Override
	public S getService() {
		logger.debug("Locating service of type : "
				+ this.serviceClass.getName());
		S service = null;

		try {
			Object endpoint = serviceLocator.getService();

			logger.debug("Found service endpoint of type: "
					+ endpoint.getClass().getName());

			service = clientFactory.newClient(endpoint);
		} catch (Exception e) {
			logger.debug("Failed to find service", e);
		}

		return service;
	}

	public eu.dnetlib.enabling.tools.ServiceLocator<?> getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(
			eu.dnetlib.enabling.tools.ServiceLocator<?> serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public Class<S> getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(Class<S> serviceClass) {
		this.serviceClass = serviceClass;
	}

	public void setClientFactory(ServiceClientFactory<S> clientFactory) {
		this.clientFactory = clientFactory;
	}
}