/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.store.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.StoreService;
import eu.dnetlib.api.data.StoreServiceException;
import eu.dnetlib.data.sts.ds.DepotServiceException;
import eu.dnetlib.data.sts.ds.IDepotService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.StoreInfo;
import eu.dnetlib.domain.data.StoreObjectInfo;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.utils.ServiceIdentityFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;

public class StoreServiceWSClient
implements StoreService {
    private static Logger logger = Logger.getLogger(StoreServiceWSClient.class);
    private String serviceUrl = null;
    private IDepotService service = null;

    public StoreServiceWSClient(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(IDepotService.class);
        factory.setAddress(serviceUrl);
        this.service = (IDepotService)factory.create();
    }

    public StoreServiceWSClient() {
    }

    public void setWebService(Object webService) {
        BindingProvider prov = (BindingProvider)webService;
        W3CEndpointReference w3cepr = (W3CEndpointReference)prov.getEndpointReference(W3CEndpointReference.class);
        EPR epr = EPRUtils.createEPR((W3CEndpointReference)w3cepr);
        this.serviceUrl = epr.getAddress();
        this.service = (IDepotService)webService;
        logger.debug((Object)("Setting serviceUrl to: " + this.serviceUrl));
    }

    public ServiceIdentity identify() {
        return ServiceIdentityFactory.parseIdentity((String)this.service.identify());
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public StoreInfo createStore(List<String> predefinedObjectTypes, long maxSizeStoreDS) throws StoreServiceException {
        try {
            String storeId = this.service.createStore(predefinedObjectTypes, maxSizeStoreDS);
            logger.debug((Object)("Created store with id: " + storeId));
            StoreInfo storeInfo = new StoreInfo();
            storeInfo.setServiceUrl(this.serviceUrl);
            storeInfo.setStoreId(storeId);
            return storeInfo;
        }
        catch (Exception e) {
            throw new StoreServiceException((Throwable)e);
        }
    }

    public void deleteStore(String storeId) throws StoreServiceException {
        try {
            logger.debug((Object)("Deleting store with id: " + storeId));
            this.service.deleteStore(storeId);
        }
        catch (Exception e) {
            throw new StoreServiceException((Throwable)e);
        }
    }

    public boolean deleteStoreObject(String storeId, List<String> storeObjectIds) throws StoreServiceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleting from store " + storeId + " objects with" + " ids " + Arrays.toString(storeObjectIds.toArray(new String[0]))));
            }
            return this.service.deleteStoreObject(storeId, storeObjectIds);
        }
        catch (Exception e) {
            throw new StoreServiceException((Throwable)e);
        }
    }

    @Deprecated
    public boolean deleteStoreObjectFromRS(String storeId, EPR rsEPR) throws StoreServiceException {
        throw new UnsupportedOperationException();
    }

    public List<StoreObjectInfo> storeObjects(String storeId, List<String> objectsForStoring, StoreService.DataType dataType, StoreService.StoringType storingType) throws StoreServiceException {
        try {
            ArrayList<String> storeObjects = new ArrayList<String>();
            ArrayList<StoreObjectInfo> objectInfoList = new ArrayList<StoreObjectInfo>();
            StoreInfo storeInfo = new StoreInfo();
            storeInfo.setServiceUrl(this.serviceUrl);
            storeInfo.setStoreId(storeId);
            for (String object : objectsForStoring) {
                String objectId = this.generateRandomID(object);
                StoreObjectInfo objectInfo = new StoreObjectInfo();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Storing object " + object + " to store with" + " id " + storeId + ". DataType: " + dataType + ", StoringType: " + storingType + ", objectId: " + objectId));
                }
                storeObjects.add(this.getStoreRecord(object, dataType, objectId));
                objectInfo.setObjectId(objectId);
                objectInfo.setStoreInfo(storeInfo);
                objectInfoList.add(objectInfo);
            }
            String actionId = this.service.storeObjects(storeId, storeObjects, storingType.getValue(), false);
            logger.debug((Object)("Store action id: " + actionId));
            return objectInfoList;
        }
        catch (DepotServiceException e) {
            throw new StoreServiceException((Throwable)e);
        }
    }

    private String getStoreRecord(String objectForStoring, StoreService.DataType dataType, String objectId) {
        StringBuilder builder = new StringBuilder();
        builder.append("<storeRecord><storeRecordIdentifier>");
        builder.append(objectId);
        builder.append("</storeRecordIdentifier><storeObject datatype=\"");
        builder.append(dataType.getValue());
        builder.append("\" >").append(objectForStoring);
        builder.append("</storeObject></storeRecord>");
        logger.debug((Object)("store record: " + builder.toString()));
        return builder.toString();
    }

    private String generateRandomID(String object) {
        return System.currentTimeMillis() + "-" + object.hashCode();
    }

    public List<StoreObjectInfo> storeObjectsFromRS(String storeId, EPR rsEPR, StoreService.DataType dataType, StoreService.StoringType storingType) throws StoreServiceException {
        throw new UnsupportedOperationException();
    }

    public boolean updateStore(String storeId, long maxSizeStoreDS, List<String> predefinedObjectTypes) throws StoreServiceException {
        try {
            return this.service.updateStore(storeId, maxSizeStoreDS, predefinedObjectTypes);
        }
        catch (Exception e) {
            throw new StoreServiceException((Throwable)e);
        }
    }
}

