/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.utils.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.clients.utils.ws.CompatibilityTransportConfiguration;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.utils.resolver.EndpointResolver;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class CompatibilityEndpointResolver
implements EndpointResolver {
    private ServiceResolver serviceResolver = null;
    private CompatibilityTransportConfiguration config = null;
    private Map<Class<?>, ServiceClientFactory<?>> clientFactoryMap = null;
    private Map<String, DriverService> serviceCache = new HashMap<String, DriverService>();

    public <T extends DriverService> T getService(Class<T> clazz, EPR epr) {
        String address = epr.getAddress();
        Object service = this.serviceCache.get(address);
        if (service == null) {
            W3CEndpointReference w3cEpr = EPRUtils.createW3CEPR((EPR)epr);
            Class<?> endpointClass = this.getEndpointClass(clazz);
            Object endpoint = this.serviceResolver.getService(endpointClass, w3cEpr);
            service = this.createServiceClient(clazz, endpoint);
            this.serviceCache.put(address, (DriverService)service);
        }
        return (T)service;
    }

    private <T extends DriverService> Class<?> getEndpointClass(Class<T> serviceClass) {
        return this.config.getEndpointClass(serviceClass);
    }

    private <T extends DriverService> T createServiceClient(Class<T> clazz, Object endpoint) {
        ServiceClientFactory<?> clientFactory = this.clientFactoryMap.get(clazz);
        DriverService client = clientFactory.newClient(endpoint);
        return (T)client;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public CompatibilityTransportConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompatibilityTransportConfiguration config) {
        this.config = config;
    }

    public Map<Class<?>, ServiceClientFactory<?>> getClientFactoryMap() {
        return this.clientFactoryMap;
    }

    public void setClientFactoryMap(Map<Class<?>, ServiceClientFactory<?>> clientFactoryMap) {
        this.clientFactoryMap = clientFactoryMap;
    }
}

