package eu.dnetlib.clients.enabling.actionmanager.ws;

import java.util.List;

import org.apache.log4j.Logger;

import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.enabling.ActionManagerService;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;

public class ActionManagerServiceClient implements ActionManagerService {
	
	private static Logger logger = Logger.getLogger(ActionManagerServiceClient.class);
	
	private eu.dnetlib.actionmanager.rmi.ActionManagerService service = null;
	

	@Override
	public String createSet(ActionManagerSet set) throws ActionManagerException {
		return service.createSet(set);
	}

	@Override
	public List<ActionManagerSet> ListSets() throws ActionManagerException {
		return service.ListSets();
	}

	@Override
	public String createAction(String splitRuleId, String set, Agent agent,
			Operation operation, String infoPackage, Provenance provenance,
			String trust, String nsprefix) throws ActionManagerException {
		return service.createAction(splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
	}

	@Override
	public String updateAction(String actionId, String splitRuleId, String set,
			Agent agent, Operation operation, String infoPackage,
			Provenance provenance, String trust, String nsprefix)
			throws ActionManagerException {
		return service.updateAction(actionId, splitRuleId, set, agent, operation, infoPackage, provenance, trust, nsprefix);
	}

	@Override
	public boolean deleteAction(String actionId) throws ActionManagerException {
		return service.deleteAction(actionId);
	}

	@Override
	public List<String> getActionsByAgent(String agentId, int limit)
			throws ActionManagerException {
		return service.getActionsByAgent(agentId, limit);
	}

	@Override
	public ServiceIdentity identify() {
		return null;
	}

	@Override
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();
	}
	
	public void setWebService(Object webService) {
		this.service = (eu.dnetlib.actionmanager.rmi.ActionManagerService) webService;
	}
	
	public void setPortType(eu.dnetlib.actionmanager.rmi.ActionManagerService portType) {
		this.service = portType;
	}
}
