package eu.dnetlib.clients.utils.ws;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import eu.dnetlib.utils.EPRUtils;
import gr.uoa.di.driver.util.ServiceLocator;

/**
 * An implementation of the ServiceLocator that creates a service client.
 * 
 * It is similar to a StaticLocator as it holds a predefined reference to a 
 * service. Their difference is that this locator also creates the service 
 * client instead of expecting a reference to it.
 * 
 * It holds no cache of the located service. Any subsequent call to getService()
 * will produce a new client. It is up to the caller to cache and refresh the 
 * result.
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 *
 * @param <S>
 */
public class JaxwsServiceLocator<S extends DriverService> implements ServiceLocator<S> {
	
	private static Logger logger = Logger.getLogger(JaxwsServiceLocator.class);

	/** The location of the service */
	private String url = null;
	/** The builder that will create the epr from the service url */
	private StandaloneCxfEndpointReferenceBuilder eprBuilder = null;
	/** The resolver that will create the client from the epr */
	private CompatibilityEndpointResolver resolver = null;
	/** The actual class of the service */
	private Class<S> serviceClass = null;

	@Override
	public S getService() {
		if (logger.isDebugEnabled())
			logger.debug("Creating client for service "
					+ serviceClass.getSimpleName() + ", url: " + url);

		W3CEndpointReference epr = eprBuilder.getEndpointReference(url, null,
				null, url + "?wsdl", null, null);

		return resolver.getService(serviceClass, EPRUtils.createEPR(epr));
	}


	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
		return eprBuilder;
	}

	public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	public CompatibilityEndpointResolver getResolver() {
		return resolver;
	}

	public void setResolver(CompatibilityEndpointResolver resolver) {
		this.resolver = resolver;
	}

	public Class<S> getServiceClass() {
		return serviceClass;
	}

	public void setServiceClass(Class<S> serviceClass) {
		this.serviceClass = serviceClass;
	}
}
