package eu.dnetlib.clients.data.mdstore.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.MDStoreService;
import eu.dnetlib.api.data.MDStoreServiceException;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;

import java.util.List;

/**
 * Created by antleb on 9/8/14.
 */
public class MDStoreServiceWSClient implements MDStoreService {
	private eu.dnetlib.data.mdstore.MDStoreService service = null;

	public void setClient(eu.dnetlib.data.mdstore.MDStoreService service) {
		this.service = service;
	}

	public void setWebService(Object service) {
		this.service = (eu.dnetlib.data.mdstore.MDStoreService) service;
	}

	@Override
	public EPR deliverMDRecords(String mdStoreId, String from, String until, String recordsFilter) throws MDStoreServiceException {
		try {
			return EPRUtils.createEPR(service.deliverMDRecords(mdStoreId, from, until, recordsFilter));
		} catch (eu.dnetlib.data.mdstore.MDStoreServiceException e) {
			throw new MDStoreServiceException("Error delivering records", e);
		}
	}

	@Override
	public String deliverRecord(String mdStoreId, String recordId) throws MDStoreServiceException {
		try {
			return service.deliverRecord(mdStoreId, recordId);
		} catch (DocumentNotFoundException e) {
			throw new MDStoreServiceException("Error delivering record", e);
		}
	}

	@Override
	public EPR bulkDeliverMDRecords(String format, String layout, String interpretation) throws MDStoreServiceException {
		try {
			return EPRUtils.createEPR(service.bulkDeliverMDRecords(format, layout, interpretation));
		} catch (eu.dnetlib.data.mdstore.MDStoreServiceException e) {
			throw new MDStoreServiceException("Error delivering records", e);
		}
	}

	@Override
	public List<String> getListOfMDStores() throws MDStoreServiceException {
		throw new UnsupportedOperationException();
	}

	@Override
	public List<String> listMDStores(String format, String layout, String interpretation) throws MDStoreServiceException {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean storeMDRecordsFromRS(String mdStoreId, String resultSetId, String storingType) throws MDStoreServiceException {
		throw new UnsupportedOperationException();
	}

	@Override
	public ServiceIdentity identify() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void notify(Notification notification) throws DriverServiceException {
		throw new UnsupportedOperationException();
	}
}