package eu.dnetlib.clients.ws;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.ServiceIdentityFactory;

public abstract class BaseWebServiceClient<WS extends DriverWebService<? extends DriverService>>
		implements DriverService {

	protected WS webService = null;

	@Override
	public final ServiceIdentity identify() {
		String identity = webService.identify();

		if (identity != null)
			return ServiceIdentityFactory.parseIdentity(webService.identify());
		else
			return null;
	}

	@Override
	public final void notify(Notification notification)
			throws DriverServiceException {
		try {
			webService.notify(
					notification.getSubscriptionId(), 
					notification.getTopic(),
					notification.getIsId(),
					notification.getMessage());
		} catch (Exception e) {
			throw new DriverServiceException(e);
		}
	}
	
	public final WS getWebService() {
		return webService;
	}

	public final void setWebService(WS webService) {
		this.webService = webService;
	}
	
	@SuppressWarnings("unchecked")
	public final void setWebService(Object webService) {
		this.webService = (WS) webService;
	}
}
