/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.index.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.Hint;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.log4j.Logger;

public class IndexWSClient
implements IndexService {
    private static Logger logger = Logger.getLogger(IndexWSClient.class);
    IIndexService client = null;

    public void setClient(IIndexService client) {
        this.client = client;
    }

    public IIndexService getClient() {
        return this.client;
    }

    public void setWebService(Object webService) {
        this.client = (IIndexService)webService;
    }

    public EPR getBrowsingStatistics(String query, String index, String mdFormatId, String layoutId) throws IndexServiceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request Browsing Statistics for \"" + query + "\" on index " + index + " with " + mdFormatId + "/" + layoutId));
            }
            W3CEndpointReference w3cEpr = this.client.getBrowsingStatistics(query, index, mdFormatId, layoutId);
            EPR epr = EPRUtils.createEPR((W3CEndpointReference)w3cEpr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result EPR: \"" + epr + "\""));
            }
            return epr;
        }
        catch (eu.dnetlib.data.index.IndexServiceException e) {
            throw new IndexServiceException("Error calling index: " + e.getMessage());
        }
    }

    public String getIndexStatistics(String index) throws IndexServiceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request Index Statistics on index " + index));
            }
            return this.client.getIndexStatistics(index);
        }
        catch (eu.dnetlib.data.index.IndexServiceException e) {
            throw new IndexServiceException("Error calling index: " + e.getMessage());
        }
    }

    public List<String> getListOfIndices() throws IndexServiceException {
        String[] list;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Request List of Indices");
        }
        if ((list = this.client.getListOfIndices()) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"List is null");
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("List contains " + list.length + " elements"));
        }
        return Arrays.asList(list);
    }

    public String getListOfIndicesCSV() throws IndexServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Request List of Indices CSV");
        }
        return this.client.getListOfIndicesCSV();
    }

    public EPR indexLookup(String id, String query, String mdformat, String layout) throws IndexServiceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Index Lookup for \"" + query + "\" on index " + id + " using " + mdformat + "/" + layout));
            }
            W3CEndpointReference w3cEpr = this.client.indexLookup(id, query, mdformat, layout);
            EPR epr = EPRUtils.createEPR((W3CEndpointReference)w3cEpr);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result EPR: \"" + epr + "\""));
            }
            return epr;
        }
        catch (eu.dnetlib.data.index.IndexServiceException e) {
            throw new IndexServiceException("Error calling index: " + e.getMessage());
        }
    }

    public ServiceIdentity identify() {
        throw new UnsupportedOperationException();
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public Hint suggestiveSearch(String id, String query, String mdformat, String layout, String heuristicProfileName) throws IndexServiceException {
        logger.debug((Object)("Ask hint for '" + query + "'"));
        Hint hint = new Hint();
        if (query.equals("query=(tost)")) {
            hint.setAlternateTerm("(test)");
            hint.setAutoFollowHint(false);
        } else if (query.equals("query=(luve)")) {
            hint.setAlternateTerm("love");
            hint.setAutoFollowHint(true);
        } else {
            hint.setAlternateTerm(null);
        }
        return hint;
    }
}

