/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.enabling.resultset.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.enabling.ResultSetServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.utils.EPRUtils;
import eu.dnetlib.utils.ServiceIdentityFactory;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;

public class ResultSetServiceWSClient
implements eu.dnetlib.api.enabling.ResultSetService {
    private Logger logger = Logger.getLogger(ResultSetServiceWSClient.class);
    private int pageSize = 500;
    private ResultSetService client = null;

    public ResultSetServiceWSClient() {
    }

    public ResultSetServiceWSClient(String url) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ResultSetService.class);
        factory.setAddress(url);
        this.client = (ResultSetService)factory.create();
    }

    public ResultSetService getClient() {
        return this.client;
    }

    public void setClient(ResultSetService client) {
        this.client = client;
    }

    public void closeRS(String rsId) {
        this.client.closeRS(rsId);
    }

    public EPR createPullRS(String dataProviderServiceAddress, String bdId, int initialPageSize, int expiryTime, String styleSheet, Integer keepAliveTime, Integer total) {
        return ResultSetServiceWSClient.createEPR(this.client.createPullRS(dataProviderServiceAddress, bdId, initialPageSize, expiryTime, styleSheet, keepAliveTime, total));
    }

    public EPR createPullRSEPR(EPR dataProviderEPR, String bdId, int initialPageSize, int expiryTime, String styleSheet, Integer keepAliveTime, Integer total) {
        return ResultSetServiceWSClient.createEPR(this.client.createPullRSEPR(ResultSetServiceWSClient.createW3CEPR(dataProviderEPR), bdId, initialPageSize, expiryTime, styleSheet, keepAliveTime, total));
    }

    public EPR createPushRS(int expiryTime, int keepAliveTime) throws ResultSetServiceException {
        try {
            return ResultSetServiceWSClient.createEPR(this.client.createPushRS(expiryTime, keepAliveTime));
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error creating push rs.", (Throwable)rse);
        }
        catch (SOAPFaultException sfe) {
            throw new ResultSetServiceException("Error getting number of elements.", (Throwable)sfe);
        }
    }

    public int getNumberOfElements(String rsId) throws ResultSetServiceException {
        try {
            return this.client.getNumberOfElements(rsId);
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error getting number of elements.", (Throwable)rse);
        }
        catch (SOAPFaultException sfe) {
            throw new ResultSetServiceException("Error getting number of elements.", (Throwable)sfe);
        }
    }

    public String getProperty(String rsId, String name) throws ResultSetServiceException {
        try {
            return this.client.getProperty(rsId, name);
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error getting property.", (Throwable)rse);
        }
    }

    public String getRSStatus(String rsId) throws ResultSetServiceException {
        try {
            return this.client.getRSStatus(rsId);
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error getting rs status.", (Throwable)rse);
        }
        catch (SOAPFaultException sfe) {
            throw new ResultSetServiceException("Error getting result set state.", (Throwable)sfe);
        }
    }

    public List<String> getResult(String rsId, int fromPosition, int toPosition, String requestMode) throws ResultSetServiceException {
        this.logger.debug((Object)("Returning results from " + fromPosition + " to " + toPosition));
        this.logger.debug((Object)"HELLO!");
        try {
            ArrayList<String> list = new ArrayList<String>();
            int requestSize = toPosition - fromPosition + 1;
            int pages = requestSize < this.pageSize ? 0 : requestSize / this.pageSize;
            int left = requestSize % this.pageSize;
            this.logger.debug((Object)("PAGES " + pages));
            for (int i = 0; i < pages; ++i) {
                this.logger.debug((Object)("FROM " + (fromPosition + i * this.pageSize)));
                this.logger.debug((Object)("TO " + (fromPosition + (i + 1) * this.pageSize - 1)));
                List res = this.client.getResult(rsId, fromPosition + i * this.pageSize, fromPosition + (i + 1) * this.pageSize - 1, requestMode);
                if (res != null) {
                    list.addAll(res);
                }
                this.logger.debug((Object)("LIST SIZE " + list.size()));
            }
            this.logger.debug((Object)("LEFT " + left));
            if (left > 0) {
                list.addAll(this.client.getResult(rsId, toPosition - left + 1, toPosition, requestMode));
            }
            this.logger.debug((Object)("LIST SIZE " + list.size()));
            return list;
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error getting result.", (Throwable)rse);
        }
        catch (SOAPFaultException sfe) {
            throw new ResultSetServiceException("Error getting results.", (Throwable)sfe);
        }
    }

    public static void main(String[] args) {
        System.out.println(1);
    }

    public String populateRS(String rsId, List<String> elements) throws ResultSetServiceException {
        int requestSize = elements.size();
        int pages = requestSize / this.pageSize;
        int left = requestSize % this.pageSize;
        try {
            for (int i = 0; i < pages; ++i) {
                this.client.populateRS(rsId, elements.subList(i * this.pageSize, (i + 1) * this.pageSize));
            }
            if (left > 0) {
                this.client.populateRS(rsId, elements.subList(pages * this.pageSize, requestSize));
            }
            return null;
        }
        catch (ResultSetException rse) {
            throw new ResultSetServiceException("Error getting number of elements.", (Throwable)rse);
        }
        catch (SOAPFaultException sfe) {
            throw new ResultSetServiceException("Error getting number of elements.", (Throwable)sfe);
        }
    }

    static EPR createEPR(W3CEndpointReference w3cEpr) {
        return EPRUtils.createEPR((W3CEndpointReference)w3cEpr);
    }

    static W3CEndpointReference createW3CEPR(EPR epr) {
        return EPRUtils.createW3CEPR((EPR)epr);
    }

    public ServiceIdentity identify() {
        return ServiceIdentityFactory.parseIdentity((String)this.client.identify());
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public void setWebService(Object webService) {
        this.client = (ResultSetService)webService;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

