/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.datasourcemanager.ws;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Converter {
    private static Logger logger = Logger.getLogger(Converter.class);

    public static Repository convertToValRepo(DatasourceDesc from) {
        logger.debug((Object)"Converting the repository to Validator format");
        Repository repo = new Repository();
        repo.setId(from.getId());
        repo.setOfficialName(from.getOfficialName());
        repo.setEnglishName(from.getEnglishName());
        repo.setWebsiteUrl(from.getWebsiteUrl());
        repo.setLogoUrl(from.getLogoUrl());
        repo.setContactEmail(from.getContactEmail());
        repo.setCountryName(from.getCountryName());
        repo.setCountryCode(from.getCountryCode());
        repo.setOrganization(from.getOrganization());
        repo.setLatitude(from.getLatitude());
        repo.setLongitude(from.getLongitude());
        repo.setTimezone(from.getTimezone());
        repo.setNamespacePrefix(from.getNamespacePrefix());
        repo.setOdNumberOfItems(from.getOdNumberOfItems());
        repo.setOdNumberOfItemsDate(from.getOdNumberOfItemsDate());
        repo.setOdPolicies(from.getOdPolicies());
        repo.setOdLanguages(from.getOdLanguages());
        repo.setOdContentTypes(from.getOdContentTypes());
        repo.setCollectedFrom(from.getCollectedFrom());
        repo.setInferred(from.isInferred());
        repo.setDeletedByInference(from.isDeletedByInference());
        repo.setTrust(from.getTrust());
        repo.setTrust(Double.valueOf(0.9));
        repo.setInferenceProvenance(from.getInferenceProvenance());
        repo.setDateOfValidation(from.getDateOfValidation());
        repo.setDatasourceClass(from.getDatasourceClass());
        repo.setProvenanceActionClass(from.getProvenanceActionClass());
        repo.setDateOfCollection(from.getDateOfCollection());
        repo.setTypology(from.getTypology());
        repo.setActivationId(from.getActivationId());
        repo.setMergehomonyms(from.isMergehomonyms());
        repo.setDescription(from.getDescription());
        repo.setReleaseStartDate(from.getReleaseStartDate());
        repo.setReleaseEndDate(from.getReleaseEndDate());
        repo.setMissionStatementUrl(from.getMissionStatementUrl());
        repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
        repo.setDataProvider(from.isDataProvider());
        repo.setServiceProvider(from.isServiceProvider());
        repo.setDatabaseAccessType(from.getDatabaseAccessType());
        repo.setDataUploadType(from.getDataUploadType());
        repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
        repo.setDataUploadRestriction(from.getDataUploadRestriction());
        repo.setVersioning(from.isVersioning());
        repo.setCitationGuidelineUrl(from.getCitationGuidelineUrl());
        repo.setQualityManagementKind(from.getQualityManagementKind());
        repo.setPidSystems(from.getPidSystems());
        repo.setCertificates(from.getCertificates());
        repo.setAggregator(from.getAggregator());
        repo.setIssn(from.getIssn());
        repo.setEissn(from.getEissn());
        repo.setLissn(from.getLissn());
        repo.setRegisteredBy(from.getRegisteredBy());
        repo.setInterfaces(Converter.convertToValIfaceList(from.getInterfaces()));
        return repo;
    }

    public static DatasourceDesc convertToDsmRepo(Repository from) {
        logger.debug((Object)"Converting the repository to Dsm format");
        DatasourceDesc repo = new DatasourceDesc();
        repo.setId(from.getId());
        repo.setOfficialName(from.getOfficialName());
        repo.setEnglishName(from.getEnglishName());
        repo.setWebsiteUrl(from.getWebsiteUrl());
        repo.setLogoUrl(from.getLogoUrl());
        repo.setContactEmail(from.getContactEmail());
        repo.setCountryName(from.getCountryName());
        repo.setCountryCode(from.getCountryCode());
        repo.setOrganization(from.getOrganization());
        repo.setLatitude(from.getLatitude());
        repo.setLongitude(from.getLongitude());
        repo.setTimezone(from.getTimezone());
        repo.setNamespacePrefix(from.getNamespacePrefix());
        repo.setOdNumberOfItems(from.getOdNumberOfItems());
        repo.setOdNumberOfItemsDate(from.getOdNumberOfItemsDate());
        repo.setOdPolicies(from.getOdPolicies());
        repo.setOdLanguages(from.getOdLanguages());
        repo.setOdContentTypes(from.getOdContentTypes());
        repo.setCollectedFrom(from.getCollectedFrom());
        repo.setInferred(from.getInferred());
        repo.setInferred(Boolean.valueOf(false));
        repo.setDeletedByInference(from.getDeletedByInference());
        repo.setDeletedByInference(Boolean.valueOf(false));
        repo.setTrust(from.getTrust());
        repo.setTrust(Double.valueOf(0.9));
        repo.setInferenceProvenance(from.getInferenceProvenance());
        repo.setDateOfValidation(from.getDateOfValidation());
        repo.setDatasourceClass(from.getDatasourceClass());
        repo.setProvenanceActionClass(from.getProvenanceActionClass());
        repo.setDateOfCollection(from.getDateOfCollection());
        repo.setTypology(from.getTypology());
        repo.setActivationId(from.getActivationId());
        repo.setMergehomonyms(from.getMergehomonyms());
        repo.setMergehomonyms(Boolean.valueOf(true));
        repo.setDescription(from.getDescription());
        repo.setReleaseStartDate(from.getReleaseStartDate());
        repo.setReleaseEndDate(from.getReleaseEndDate());
        repo.setMissionStatementUrl(from.getMissionStatementUrl());
        repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
        repo.setDataProvider(from.getDataProvider());
        repo.setDataProvider(Boolean.valueOf(false));
        repo.setServiceProvider(from.getServiceProvider());
        repo.setServiceProvider(Boolean.valueOf(false));
        repo.setDatabaseAccessType(from.getDatabaseAccessType());
        repo.setDataUploadType(from.getDataUploadType());
        repo.setDatabaseAccessRestriction(from.getDatabaseAccessRestriction());
        repo.setDataUploadRestriction(from.getDataUploadRestriction());
        repo.setVersioning(from.getVersioning());
        repo.setVersioning(Boolean.valueOf(false));
        repo.setCitationGuidelineUrl(from.getCitationGuidelineUrl());
        repo.setQualityManagementKind(from.getQualityManagementKind());
        repo.setPidSystems(from.getPidSystems());
        repo.setCertificates(from.getCertificates());
        repo.setAggregator(from.getAggregator());
        repo.setIssn(from.getIssn());
        repo.setEissn(from.getEissn());
        repo.setLissn(from.getLissn());
        repo.setRegisteredBy(from.getRegisteredBy());
        repo.setInterfaces(Converter.convertToDsmIfaceList(from.getInterfaces()));
        return repo;
    }

    public static RepositoryInterface convertToValIface(IfaceDesc from) {
        logger.debug((Object)"Converting the interface to Validator format");
        RepositoryInterface newIface = new RepositoryInterface();
        if (from == null) {
            logger.debug((Object)"iface 'from' iss null!!");
        } else {
            if (from.getId() == null) {
                logger.debug((Object)"iface ID is null ");
            } else {
                logger.debug((Object)("iface ID: " + from.getId()));
            }
            newIface.setId(from.getId());
            newIface.setTypology(from.getTypology());
            newIface.setCompliance(from.getCompliance());
            newIface.setBaseUrl(from.getBaseUrl());
            newIface.setAccessProtocol(from.getAccessProtocol());
            newIface.setActive(from.getActive());
            newIface.setContentDescription(from.getContentDescription());
            newIface.setRemovable(from.getRemovable());
            newIface.setExtraFields(from.getExtraFields());
            newIface.setAccessParams(from.getAccessParams());
        }
        return newIface;
    }

    public static IfaceDesc convertToDsmIface(RepositoryInterface from) {
        logger.debug((Object)"Converting the interface to Dsm format");
        IfaceDesc newIface = new IfaceDesc();
        try {
            newIface.setId(from.getId());
            newIface.setTypology(from.getTypology());
            newIface.setCompliance(from.getCompliance());
            newIface.setBaseUrl(from.getBaseUrl());
            newIface.setAccessProtocol(from.getAccessProtocol());
            newIface.setActive(from.isActive());
            newIface.setContentDescription(from.getContentDescription());
            newIface.setRemovable(from.isRemovable());
            newIface.setExtraFields(from.getExtraFields());
            newIface.setAccessParams(from.getAccessParams());
        }
        catch (Exception e) {
            logger.error((Object)("Converting the interface to Dsm format " + e));
        }
        return newIface;
    }

    public static List<RepositoryInterface> convertToValIfaceList(List<IfaceDesc> fromList) {
        logger.debug((Object)"Converting the interfaces to Validation format");
        logger.debug((Object)("Number of interfaces to be converted: " + fromList.size()));
        ArrayList<RepositoryInterface> interfaces = new ArrayList<RepositoryInterface>();
        for (IfaceDesc from : fromList) {
            if (from == null) {
                logger.debug((Object)"iface is null: ");
            }
            interfaces.add(Converter.convertToValIface(from));
        }
        return interfaces;
    }

    public static List<IfaceDesc> convertToDsmIfaceList(List<RepositoryInterface> fromList) {
        logger.debug((Object)"Converting the interfaces to dsm format");
        logger.debug((Object)("Number of interfaces to be converted: " + fromList.size()));
        ArrayList<IfaceDesc> interfaces = new ArrayList<IfaceDesc>();
        for (RepositoryInterface from : fromList) {
            interfaces.add(Converter.convertToDsmIface(from));
        }
        return interfaces;
    }

    public static List<Repository> convertToValRepoList(List<DatasourceDesc> fromList) {
        logger.debug((Object)"Converting the repositories to Validation format");
        logger.debug((Object)("Number of repositories to be converted: " + fromList.size()));
        ArrayList<Repository> retList = new ArrayList<Repository>();
        for (DatasourceDesc from : fromList) {
            retList.add(Converter.convertToValRepo(from));
        }
        return retList;
    }

    public static List<DatasourceDesc> convertToDsmRepoList(List<Repository> fromList) {
        logger.debug((Object)"Converting the repositories to Dsm format");
        logger.debug((Object)("Number of repositories to be converted: " + fromList.size()));
        ArrayList<DatasourceDesc> retList = new ArrayList<DatasourceDesc>();
        for (Repository from : fromList) {
            retList.add(Converter.convertToDsmRepo(from));
        }
        return retList;
    }
}

