/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.action;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.action.Relation;
import eu.dnetlib.openaire.thrift.Author;
import eu.dnetlib.openaire.thrift.Project;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class ActionUtils {
    private static Logger logger = Logger.getLogger(ActionUtils.class);

    public static String createResultProjectRelation(String source, String resultId, String projectType, String projectId) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        ve.init();
        Template t = ve.getTemplate("/eu/dnetlib/openaire/action/relation.vm");
        VelocityContext vc = new VelocityContext();
        ArrayList<Relation> rels = new ArrayList<Relation>();
        rels.add(ActionUtils.createRelation(source, resultId, projectType, projectId));
        vc.put("relations", rels);
        StringWriter sw = new StringWriter();
        t.merge((Context)vc, (Writer)sw);
        return sw.toString();
    }

    public static String createResultResultRelation(String sourceResultId, String sourceResultType, String targetResultId, String targetResultType) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        ve.init();
        Template t = ve.getTemplate("/eu/dnetlib/openaire/action/relation.vm");
        VelocityContext vc = new VelocityContext();
        ArrayList<Relation> rels = new ArrayList<Relation>();
        rels.add(new Relation("resultResult_" + sourceResultType + targetResultType + "_isRelatedTo", "50|" + sourceResultId, "50|" + targetResultId));
        vc.put("relations", rels);
        StringWriter sw = new StringWriter();
        t.merge((Context)vc, (Writer)sw);
        return sw.toString();
    }

    private static Relation createRelation(String source, String resultId, String projectType, String projectId) {
        String projectPrefix = null;
        if (!ActionUtils.isValidOpenaireId(resultId) && source != null) {
            if (source.equals("arxiv")) {
                resultId = "oai:arXiv.org:" + resultId;
            } else if (source.equals("pubmed")) {
                resultId = "oai:europepmc.org:" + resultId;
            }
            String resultPrefix = ActionUtils.getPrefix(source);
            resultId = ActionUtils.getIdentifier(resultPrefix, resultId);
        }
        resultId = "50|" + resultId;
        if (projectType != null) {
            if (projectType.equals("ec")) {
                projectPrefix = "corda_______";
            } else if (projectType.equals("wt")) {
                projectPrefix = "wt__________::WT";
            }
            projectId = projectPrefix + "::" + projectId;
        }
        projectId = "40|" + projectId;
        return new Relation("resultProject", resultId, projectId);
    }

    private static boolean isValidOpenaireId(String resultId) {
        return Pattern.matches("\\w{12}::[a-f0-9]{32}", resultId);
    }

    public static String getPrefix(String source) {
        logger.debug((Object)("SOURCE " + source));
        if (source == null || source.equals("openaire")) {
            return "openaire____";
        }
        if (source.equals("doi")) {
            return "crossref____";
        }
        if (source.equals("orcid")) {
            return "orcid_______";
        }
        if (source.equals("datacite")) {
            return "datacite____";
        }
        if (source.equals("driver")) {
            return "driver______";
        }
        return null;
    }

    public static String getProvenance(String source) {
        if (source == null || source.equals("openaire")) {
            return "user:claim:search";
        }
        if (source.equals("doi") || source.equals("orcid")) {
            return "user:claim:pid";
        }
        if (source.equals("datacite")) {
            return "user:claim:datacite";
        }
        return null;
    }

    public static String createDMF(String id, String source, String title, String description, String access_mode, String embargoEndDate, List<Author> authors, String url, String dcSource, String doi, List<Project> projects, List<String> subjects, List<String> concepts, String publicationDate, String publisher, String language, String category) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        ve.init();
        Template t = ve.getTemplate("/eu/dnetlib/openaire/action/dmf.vm");
        VelocityContext vc = new VelocityContext();
        String hostedby = null;
        String hostedbyName = null;
        String collectedFrom = null;
        String collectedFromName = null;
        String recordIdentifier = id;
        String prefix = ActionUtils.getPrefix(source);
        String orcid = null;
        if (source.equals("doi")) {
            hostedby = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";
            hostedbyName = "Unknown Repository";
            collectedFrom = "openaire____::crossref";
            collectedFromName = "Crossref";
            doi = id;
        } else if (source.equals("datacite")) {
            hostedby = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";
            hostedbyName = "Unknown Repository";
            collectedFrom = "openaire____::datacite";
            collectedFromName = "Datacite";
        } else if (source.equals("orcid")) {
            orcid = id;
            hostedby = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";
            hostedbyName = "Unknown Repository";
            collectedFrom = "openaire____::orcid";
            collectedFromName = "ORCID";
        } else if (source.equals("driver")) {
            hostedby = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";
            hostedbyName = "Unknown Repository";
            collectedFrom = "openaire____::driver";
            collectedFromName = "Digital Repository Infrastructure Vision for European Research";
        }
        if (doi != null) {
            vc.put("doi", (Object)doi);
        } else if (orcid != null) {
            vc.put("orcid", (Object)orcid);
        }
        if (!source.equals("openaire")) {
            id = ActionUtils.getIdentifier(prefix, id);
        }
        vc.put("objIdentifier", (Object)id);
        vc.put("recordIdentifier", (Object)recordIdentifier);
        vc.put("dateOfCollection", (Object)DateUtils.calculate_ISO8601((long)System.currentTimeMillis()));
        vc.put("hostedby", (Object)hostedby);
        vc.put("collectedFrom", (Object)collectedFrom);
        vc.put("hostedbyName", (Object)hostedbyName);
        vc.put("collectedFromName", (Object)collectedFromName);
        vc.put("embargoEndDate", (Object)embargoEndDate);
        vc.put("title", (Object)title);
        vc.put("description", (Object)description);
        vc.put("accessMode", (Object)access_mode);
        vc.put("dcSource", (Object)dcSource);
        vc.put("url", (Object)url);
        vc.put("publisher", (Object)publisher);
        vc.put("language", (Object)language);
        vc.put("objCategory", (Object)category);
        vc.put("datasourceprefix", (Object)prefix);
        ArrayList<String> creators = new ArrayList<String>();
        for (Author author : authors) {
            String name = author.getLastName();
            if (author.getFirstName() != null && !author.getFirstName().trim().isEmpty()) {
                name = name + ", " + author.getFirstName();
            }
            creators.add(name);
        }
        vc.put("creators", creators);
        vc.put("projects", projects);
        vc.put("subjects", subjects);
        vc.put("concepts", concepts);
        if (publicationDate != null && !publicationDate.equals("")) {
            vc.put("publicationDate", (Object)(publicationDate + "-01-01T00:00:00Z"));
        }
        vc.put("StringEscapeUtils", StringEscapeUtils.class);
        StringWriter sw = new StringWriter();
        t.merge((Context)vc, (Writer)sw);
        return sw.toString();
    }

    public static String getIdentifier(String prefix, String id) {
        try {
            logger.debug((Object)("PREFIX " + prefix));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id.getBytes("UTF-8"));
            return prefix + "::" + new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            logger.error((Object)"Error creating id", (Throwable)e);
            return null;
        }
    }
}

