/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.thrift;

import eu.dnetlib.api.functionality.AlertService;
import eu.dnetlib.api.functionality.AlertServiceException;
import eu.dnetlib.openaire.thrift.AlertSubscription;
import eu.dnetlib.openaire.thrift.ResultPage;
import gr.uoa.di.driver.util.ServiceLocator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class AlertConnector {
    private ServiceLocator<AlertService> alertServiceLocator;

    public void setAlertServiceLocator(ServiceLocator<AlertService> alertServiceLocator) {
        this.alertServiceLocator = alertServiceLocator;
    }

    public List<AlertSubscription> getSubscriptions(String alertMode, String subscriber, int limit, int offset) throws AlertServiceException {
        ArrayList<AlertSubscription> subscriptions = new ArrayList<AlertSubscription>();
        for (eu.dnetlib.domain.functionality.AlertSubscription subscription : ((AlertService)this.alertServiceLocator.getService()).getSubscriptions(alertMode, subscriber, limit, offset)) {
            subscriptions.add(new AlertSubscription(subscription.getTemplateId(), subscription.getNotificationService().toString(), subscription.getQueryId(), subscription.getResultId(), subscription.getAlertMode(), subscription.getSubscriber().toString()));
        }
        return subscriptions;
    }

    public void addSubscription(AlertSubscription subscription) throws AlertServiceException, MalformedURLException, URISyntaxException {
        ((AlertService)this.alertServiceLocator.getService()).addSubscription(new eu.dnetlib.domain.functionality.AlertSubscription(subscription.getTemplateId(), new URL(subscription.getNotificationService()), subscription.getQueryId(), subscription.getResultId(), subscription.getAlertMode(), new URI(subscription.getSubscriber()), true));
    }

    public void removeSubscription(AlertSubscription subscription) throws AlertServiceException, MalformedURLException, URISyntaxException {
        ((AlertService)this.alertServiceLocator.getService()).removeSubscription(subscription.getTemplateId(), new URL(subscription.getNotificationService()), subscription.getQueryId(), subscription.getResultId(), subscription.getAlertMode(), new URI(subscription.getSubscriber()));
    }

    public int countAlertResults(String notificationService, String queryId, long date, String resultId) throws AlertServiceException, MalformedURLException {
        return ((AlertService)this.alertServiceLocator.getService()).countAlertResults(new URL(notificationService), queryId, new Date(date), resultId);
    }

    public ResultPage getAlertResults(String notificationService, String queryId, String resultId, long fromDate, long toDate, int limit, int offset) throws AlertServiceException, MalformedURLException {
        eu.dnetlib.domain.functionality.ResultPage resultPage = ((AlertService)this.alertServiceLocator.getService()).getAlertResults(new URL(notificationService), queryId, resultId, new Date(fromDate), new Date(toDate), limit, offset);
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (String[] row : resultPage.getRows()) {
            rows.add(Arrays.asList(row));
        }
        return new ResultPage(resultPage.getLimit(), resultPage.getOffset(), Arrays.asList(resultPage.getColumns()), rows);
    }
}

