/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.thrift;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.openaire.action.ActionUtils;
import eu.dnetlib.openaire.thrift.Author;
import eu.dnetlib.openaire.thrift.Claim;
import eu.dnetlib.openaire.thrift.Project;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.util.ServiceLocator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ClaimConnector {
    private static Logger logger = Logger.getLogger(ClaimConnector.class);
    private DataSource datasource = null;
    private ServiceLocator<ISLookUpService> lookupServiceLocator = null;

    public List<Claim> getClaimedPublications(String user) throws SQLException {
        Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
        PreparedStatement stmt = con.prepareStatement("select \"resultid\", \"date\" , \"type\", \"xml\", \"id\" from claims where \"agent\" = ?");
        stmt.setString(1, user);
        ResultSet rs = stmt.executeQuery();
        ArrayList<Claim> res = new ArrayList<Claim>();
        while (rs.next()) {
            res.add(new Claim(user, rs.getString(1), rs.getTimestamp(2).getTime(), rs.getString(3), rs.getString(4), rs.getString(5)));
        }
        rs.close();
        stmt.close();
        logger.info((Object)("Returning " + res.size() + " claimed publications for user " + user));
        return res;
    }

    public List<Claim> getClaimedPublications(Date from, Date to) throws SQLException {
        Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
        PreparedStatement stmt = con.prepareStatement("select \"agent\", \"resultid\", \"date\" , \"type\", \"xml\",  \"id\"  from claims where \"agent\" != 'inference' and \"date\" >= ?::timestamp and \"date\" <= ?::timestamp ");
        stmt.setTimestamp(1, new Timestamp(from.getTime()));
        stmt.setTimestamp(2, new Timestamp(to.getTime()));
        ResultSet rs = stmt.executeQuery();
        ArrayList<Claim> res = new ArrayList<Claim>();
        while (rs.next()) {
            res.add(new Claim(rs.getString(1), rs.getString(2), rs.getTimestamp(3).getTime(), rs.getString(4), rs.getString(5), rs.getString(6)));
        }
        rs.close();
        stmt.close();
        logger.debug((Object)("number of claims: " + res.size()));
        logger.info((Object)("Returning " + res.size() + " claimed publications for date " + from + "-" + to));
        return res;
    }

    public void deleteClaim(String userEmail, String id) throws SQLException {
        logger.info((Object)("Deleting claim with id " + id + " for agent " + userEmail));
        Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
        int claim_id = Integer.parseInt(id);
        String type = null;
        PreparedStatement stmt = con.prepareStatement("select \"resultid\", \"type\" from claims where \"id\" =?");
        stmt.setInt(1, claim_id);
        ResultSet rs = stmt.executeQuery();
        String resultid = null;
        String xml = null;
        while (rs.next()) {
            resultid = rs.getString("resultid");
            type = rs.getString("type");
        }
        if (resultid != null) {
            stmt = con.prepareStatement("delete from claims where \"agent\" =? and \"id\" =?");
            stmt.setString(1, userEmail);
            stmt.setInt(2, claim_id);
            stmt.executeUpdate();
            logger.info((Object)("Deleted claim with claim id: " + claim_id + ", result id: " + resultid + " and type: " + type + "."));
            int claim2_id = claim_id - 1;
            if (type != null && type.equals("rels2actions")) {
                con = DataSourceUtils.getConnection((DataSource)this.datasource);
                stmt = con.prepareStatement("select \"type\", \"xml\" from claims where \"id\" =? and \"resultid\"=?");
                stmt.setInt(1, claim2_id);
                stmt.setString(2, resultid);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    type = rs.getString("type");
                    xml = rs.getString("xml");
                }
                if (type != null && type.equals("dmf2actions") && xml != null && !xml.contains("oaf:concept")) {
                    stmt = con.prepareStatement("delete from claims where \"agent\" =? and \"id\" =? and \"resultid\" =? and \"type\" = ?");
                    stmt.setString(1, userEmail);
                    stmt.setInt(2, claim2_id);
                    stmt.setString(3, resultid);
                    stmt.setString(4, "dmf2actions");
                    stmt.executeUpdate();
                    logger.info((Object)("Deleted claim with id " + claim2_id + " and type: dmf2actions."));
                }
            }
        }
        stmt.close();
        logger.info((Object)("Deleted claim with id " + id + " for agent " + userEmail));
    }

    public String insertDocument(String id, String source, String title, String description, String access_mode, String embargoEndDate, List<Author> authors, String url, String dcSource, String userEmail, List<String> subjects, String publicationDate, String publisher, String language, String category, String doi) throws Exception {
        String resultId;
        logger.info((Object)("Request to insert document with id " + id + " and source " + source));
        try {
            Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
            resultId = ActionUtils.getIdentifier(ActionUtils.getPrefix(source), id);
            Date now = new Date();
            if (!source.toLowerCase().equals("openaire") && title != null) {
                PreparedStatement stmt = con.prepareStatement("insert into claims (\"agent\", \"resultid\", \"date\", type, xml, set, provenance, nsprefix) values (?, ?, ?, ?, ?, ?, ?, ?)");
                String dmf = ActionUtils.createDMF(id, source, title, description, access_mode, embargoEndDate, authors, url, dcSource, doi, Collections.EMPTY_LIST, subjects, Collections.EMPTY_LIST, publicationDate, publisher, language, category);
                stmt.setString(1, userEmail);
                stmt.setString(2, resultId);
                stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
                stmt.setString(4, "dmf2actions");
                stmt.setString(5, dmf);
                stmt.setString(6, "userclaim_dmf");
                stmt.setString(7, ActionUtils.getProvenance(source));
                stmt.setString(8, ActionUtils.getPrefix(source));
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error inserting document", (Throwable)e);
            throw e;
        }
        logger.info((Object)("Inserted document with id " + id + ", source " + source + " and given resultId " + resultId));
        return resultId;
    }

    public void insertConceptRelation(String documentId, String documentSource, String concept, String userEmail) throws Exception {
        logger.info((Object)("Request for concept relation between document with id " + documentId + " with source " + documentSource + " and concept " + concept));
        try {
            Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
            PreparedStatement stmt = con.prepareStatement("insert into claims (\"agent\", \"resultid\", \"date\", type, xml, set, provenance, nsprefix) values (?, ?, ?, ?, ?, ?, ?, ?)");
            String dmf = ActionUtils.createDMF(documentId, documentSource, null, null, null, null, Collections.EMPTY_LIST, null, null, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Arrays.asList(concept), null, null, null, null);
            stmt.setString(1, userEmail);
            stmt.setString(2, documentId);
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setString(4, "dmf2actions");
            stmt.setString(5, dmf);
            stmt.setString(6, "userclaim_dmf");
            stmt.setString(7, ActionUtils.getProvenance(documentSource));
            stmt.setString(8, ActionUtils.getPrefix(documentSource));
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding concept", (Throwable)e);
            throw e;
        }
        logger.info((Object)("Inserted concept relation between document with id " + documentId + " with source " + documentSource + " and concept " + concept));
    }

    public void insertProjectRelation(String docId, String documentSource, Project project, String userEmail) throws Exception {
        logger.info((Object)("Request for project relation between document with id " + docId + " with source " + documentSource + " and project " + project));
        try {
            Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
            String xml = ActionUtils.createResultProjectRelation("openaire".equals(documentSource) ? null : documentSource, docId, project.getType(), project.getProjectId());
            PreparedStatement stmt = con.prepareStatement("insert into claims (\"agent\", \"resultid\", \"date\", type, xml, set, provenance, nsprefix) values (?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setString(1, userEmail);
            stmt.setString(2, docId);
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setString(4, "rels2actions");
            stmt.setString(5, xml);
            stmt.setString(6, "userclaim_result_project");
            stmt.setString(7, ActionUtils.getProvenance(documentSource));
            stmt.setString(8, ActionUtils.getPrefix(documentSource));
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding project", (Throwable)e);
            throw e;
        }
        logger.info((Object)("Inserted project relation between document with id " + docId + " with source " + documentSource + " and project " + project));
    }

    public void insertResultRelation(String sourceResultId, String sourceResultType, String sourceResultSource, String targetResultId, String targetResultType, String userEmail) throws Exception {
        logger.info((Object)("Request for result relation between source document with id " + sourceResultId + ", type " + sourceResultType + "and source " + sourceResultSource + " and " + "target document with id " + targetResultId + ", type " + targetResultType));
        try {
            Connection con = DataSourceUtils.getConnection((DataSource)this.datasource);
            String xml = ActionUtils.createResultResultRelation(sourceResultId, sourceResultType, targetResultId, targetResultType);
            PreparedStatement stmt = con.prepareStatement("insert into claims (\"agent\", \"resultid\", \"date\", type, xml, set, provenance, nsprefix) values (?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setString(1, userEmail);
            stmt.setString(2, sourceResultId);
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setString(4, "rels2actions");
            stmt.setString(5, xml);
            stmt.setString(6, "userclaim_result_result");
            stmt.setString(7, ActionUtils.getProvenance(sourceResultSource));
            stmt.setString(8, ActionUtils.getPrefix(sourceResultSource));
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding result relation", (Throwable)e);
            throw e;
        }
        logger.info((Object)("Inserted result relation between source document with id " + sourceResultId + ", type " + sourceResultType + "and source " + sourceResultSource + " and " + "target document with id " + targetResultId + ", type " + targetResultType));
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public ServiceLocator<ISLookUpService> getLookupServiceLocator() {
        return this.lookupServiceLocator;
    }

    public void setLookupServiceLocator(ServiceLocator<ISLookUpService> lookupServiceLocator) {
        this.lookupServiceLocator = lookupServiceLocator;
    }

    public List<String> getContexts() throws ISLookUpException, ISLookUpServiceException {
        return ((ISLookUpService)this.lookupServiceLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType') return $x");
    }
}

