/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.thrift;

import eu.dnetlib.api.functionality.AlertServiceException;
import eu.dnetlib.openaire.thrift.AlertConnector;
import eu.dnetlib.openaire.thrift.AlertSubscription;
import eu.dnetlib.openaire.thrift.Author;
import eu.dnetlib.openaire.thrift.Claim;
import eu.dnetlib.openaire.thrift.ClaimConnector;
import eu.dnetlib.openaire.thrift.OpenAIREConnector;
import eu.dnetlib.openaire.thrift.Project;
import eu.dnetlib.openaire.thrift.ResultPage;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class OpenAIREConnectorImpl
implements OpenAIREConnector.Iface {
    private static final Logger logger = Logger.getLogger(OpenAIREConnectorImpl.class);
    private ClaimConnector claimConnector;
    private AlertConnector alertConnector;

    public void setClaimConnector(ClaimConnector claimConnector) {
        this.claimConnector = claimConnector;
    }

    public void setAlertConnector(AlertConnector alertConnector) {
        this.alertConnector = alertConnector;
    }

    @Override
    public List<Claim> getClaimedPublications(String user) throws TException {
        try {
            return this.claimConnector.getClaimedPublications(user);
        }
        catch (Exception e) {
            logger.error((Object)("Error retrieving claimed publications (user: " + user + ")"), (Throwable)e);
            throw new TException("Error retrieving claimed publications (user: " + user + ")", (Throwable)e);
        }
    }

    @Override
    public List<Claim> getAllClaimedPublications(long from, long to) throws TException {
        try {
            return this.claimConnector.getClaimedPublications(new Date(from), new Date(to));
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving claimed publications", (Throwable)e);
            throw new TException("Error retrieving claimed publications", (Throwable)e);
        }
    }

    @Override
    public String insertDocument(String originalId, String source, String title, String description, String access_mode, String embargoEndDate, List<Author> authors, String url, String dcSource, String userEmail, List<String> subjects, String publicationDate, String publisher, String language, String category, String doi) throws TException {
        try {
            return this.claimConnector.insertDocument(originalId, source, title, description, access_mode, embargoEndDate, authors, url, dcSource, userEmail, subjects, publicationDate, publisher, language, category, doi);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding document", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    @Override
    public void insertConcept(String docId, String documentSource, String concept, String userEmail) throws TException {
        try {
            this.claimConnector.insertConceptRelation(docId, documentSource, concept, userEmail);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding concept relation", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    @Override
    public void insertProjectRelation(String docId, String documentSource, Project project, String userEmail) throws TException {
        try {
            this.claimConnector.insertProjectRelation(docId, documentSource, project, userEmail);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding project relation", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    @Override
    public void insertResultRelation(String sourceResultId, String sourceResultType, String sourceResultSource, String targetResultId, String targetResultType, String userEmail) throws TException {
        try {
            this.claimConnector.insertResultRelation(sourceResultId, sourceResultType, sourceResultSource, targetResultId, targetResultType, userEmail);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding result relation", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    @Override
    public List<AlertSubscription> getSubscriptions(String alertMode, String subscriber, int limit, int offset) throws TException {
        try {
            return this.alertConnector.getSubscriptions(alertMode, subscriber, limit, offset);
        }
        catch (AlertServiceException e) {
            logger.error((Object)("Error retrieving subscriptions (alert mode: " + alertMode + ", subscriber: " + subscriber + ", limit: " + limit + ", offset: " + offset + ")"), (Throwable)e);
            throw new TException("Error retrieving subscriptions (alert mode: " + alertMode + ", subscriber: " + subscriber + ", limit: " + limit + ", offset: " + offset + ")", (Throwable)e);
        }
    }

    @Override
    public void addSubscription(AlertSubscription subscription) throws TException {
        try {
            this.alertConnector.addSubscription(subscription);
        }
        catch (AlertServiceException e) {
            logger.error((Object)"Error adding subscription", (Throwable)e);
            throw new TException("Error adding subscription", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Error adding subscription", (Throwable)e);
            throw new TException("Error adding subscription", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Error adding subscription", (Throwable)e);
            throw new TException("Error adding subscription", (Throwable)e);
        }
    }

    @Override
    public void removeSubscription(AlertSubscription subscription) throws TException {
        try {
            this.alertConnector.removeSubscription(subscription);
        }
        catch (AlertServiceException e) {
            logger.error((Object)"Error removing subscription", (Throwable)e);
            throw new TException("Error removing subscription", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Error removing subscription", (Throwable)e);
            throw new TException("Error removing subscription", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Error removing subscription", (Throwable)e);
            throw new TException("Error removing subscription", (Throwable)e);
        }
    }

    @Override
    public int countAlertResults(String notificationService, String queryId, long date, String resultId) throws TException {
        try {
            return this.alertConnector.countAlertResults(notificationService, queryId, date, resultId);
        }
        catch (AlertServiceException e) {
            logger.error((Object)("Error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")"), (Throwable)e);
            throw new TException("Error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")"), (Throwable)e);
            throw new TException("Error counting alert results (notification service: " + notificationService + ", query: " + queryId + ", date: " + date + ", result: " + resultId + ")", (Throwable)e);
        }
    }

    @Override
    public ResultPage getAlertResults(String notificationService, String queryId, String resultId, long fromDate, long toDate, int limit, int offset) throws TException {
        try {
            return this.alertConnector.getAlertResults(notificationService, queryId, resultId, fromDate, toDate, limit, offset);
        }
        catch (AlertServiceException e) {
            logger.error((Object)("Error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")"), (Throwable)e);
            throw new TException("Error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")"), (Throwable)e);
            throw new TException("Error retrieving alert results (notification service: " + notificationService + ", query: " + queryId + ", result: " + resultId + ", from date: " + fromDate + ", to date: " + toDate + ", limit: " + limit + ", offset: " + offset + ")", (Throwable)e);
        }
    }

    @Override
    public void deleteClaim(String userEmail, String resultId) throws TException {
        try {
            this.claimConnector.deleteClaim(userEmail, resultId);
        }
        catch (Exception e) {
            logger.error((Object)"Error deleting claim", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    @Override
    public List<String> getContexts() throws TException {
        try {
            return this.claimConnector.getContexts();
        }
        catch (Exception e) {
            logger.error((Object)"Error getting contexts from IS.", (Throwable)e);
            throw new TException((Throwable)e);
        }
    }
}

