/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.thrift;

import eu.dnetlib.openaire.thrift.OpenAIREConnector;
import org.apache.log4j.Logger;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftServer {
    private OpenAIREConnector.Iface openAireConnector;
    private int port;
    private int timeout;
    private Thread thread;

    public void setOpenAireConnector(OpenAIREConnector.Iface openAireConnector) {
        this.openAireConnector = openAireConnector;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(ThriftServer.this.port, ThriftServer.this.timeout)).processor(new OpenAIREConnector.Processor<OpenAIREConnector.Iface>(ThriftServer.this.openAireConnector))).serve();
                }
                catch (TTransportException e) {
                    Logger.getLogger(ThriftServer.class).error((Object)"Error starting thrift server", (Throwable)e);
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }
}

