namespace java eu.dnetlib.openaire.thrift

struct Author {
	1: string id,
	2: string lastName,
	3: string firstName
}

// alerts
struct AlertSubscription {
	1: string templateId,
	2: string notificationService,
	3: string queryId,
	4: string resultId,
	5: string alertMode,
	6: string subscriber
}

struct ResultPage {
	1: i32 limit,
	2: i32 offset,
	3: list<string> columns,
	4: list<list<string>> rows
}

struct Claim {
    1: string userEmail,
	2: string resultid,
	3: i64 date,
	4: string type,
	5: string xml,
	6: string id
}

struct Project {
    1: string type,
    2: string projectId
}

// connector
service OpenAIREConnector {
	// claim
	list<Claim> getClaimedPublications(1: string userEmail),

	// from: date in milisecs
	// to: ditto
	list<Claim> getAllClaimedPublications(1: i64 from, 2: i64 to),
	
	string insertDocument (
			1: string originalId,
			2: string source, 
			3: string title, 
			4: string description, 
			5: string access_mode, 
			6: string embargoEndDate, 
			7: list<Author> authors, 
			8: string url,
			9: string dcSource,
			10: string userEmail,
			11: list<string> subjects,
			12: string publicationDate,
			13: string publisher,
			14: string language,
			15: string category,
			16: string doi),

    void insertConcept (
        1: string docId,
        2: string documentSource,
        3: string concept,
        4: string userEmail),

    void insertProjectRelation (
        1: string docId,
        2: string documentSource,
        3: Project project,
        4: string userEmail),

    void insertResultRelation (
        1: string sourceResultId,
        2: string sourceResultType,
        3: string sourceResultSource,
        4: string targetResultId,
        5: string targetResultType,
        6: string userEmail
    ),

	void deleteClaim(1: string userEmail, 2:string resultId),

	// alerts
	list<AlertSubscription> getSubscriptions(
			1: string alertMode, 
			2: string subscriber, 
			3: i32 limit, 
			4: i32 offset),
			
	void addSubscription(1: AlertSubscription subscription),
	
	void removeSubscription(1: AlertSubscription subscription),
	
	i32 countAlertResults(
			1: string notificationService, 
			2: string queryId, 
			3: i64 date, 
			5: string resultId),
			
	ResultPage getAlertResults(
			1: string notificationService, 
			2: string queryId, 
			3: string resultId, 
			4: i64 fromDate, 
			5: i64 toDate, 
			6: i32 limit, 
			7: i32 offset),
	
	list<string> getContexts(),
}