package eu.dnetlib.data.statsmanager;


import eu.dnetlib.clients.data.search.ws.SearchWebService;
import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.domain.data.SearchResult;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.Base64Converter;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

import javax.net.ssl.HttpsURLConnection;
import javax.sql.DataSource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;


public class StatsManager {

    private ValidationReport validationReport;

    private Resource validationQueriesFile;
    private URL refreshShadowCacheURL;
    private URL promoteShadowCacheURL;
    private DataSource dataSource;
    private String shadowSearchURL;
    private static SearchWebService searchWebService = null;
    private String portalUser;
    private String httpsUsername;
    private String httpsPassword;

    private Logger log = Logger.getLogger(this.getClass());

    public StatsManager() {


    }


    private void initSearch() {
        if (searchWebService == null) {
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setServiceClass(SearchWebService.class);
            factory.setAddress(shadowSearchURL);
            searchWebService = (SearchWebService) factory.create();
        }
    }


    public ValidationReport validateDatabase() throws Exception {
        ValidationReport report = new ValidationReport();
        Properties p = new Properties();

        this.validationReport = report;

        try {

            //TODO initiate search
            initSearch();
            log.info("Search Client  initiated at " + this.shadowSearchURL);

        } catch (Exception e) {
            log.error(e.toString());
            throw new Exception(e);

        }


        try {

            p.loadFromXML(validationQueriesFile.getInputStream());

        } catch (Exception e) {
            log.error("Error while loading queries file :" + e.toString());
            throw new Exception(e);
            // private ServiceLocator<SearchService> searchServiceLocator;
        }


        int queryCount = Integer.parseInt(p.getProperty("queries.count"));
        log.info("Query  Count: " + queryCount + "\n");
        for (int i = 1; i <= queryCount; i++) {

            String queryType = p.getProperty("queries." + i + ".type");
            String sql = p.getProperty("queries." + i + ".sql");
            String cql = p.getProperty("queries." + i + ".cql.query");
            String name = p.getProperty("queries." + i + ".name");

            log.info("Query: " + name + "\n" + " SQL " + sql + "\n" + "CQL" + cql + "\n");
            if (queryType.equals("search")) {
                int sqlResult = executeSQLCountQuery(sql);

                int cqlResult = executeCQLCountQuery(cql);

                boolean status = validate(sqlResult, cqlResult);
                validationReport.addQuery(name, sqlResult, cqlResult, status);

            } else if (queryType.equals("browse")) {

                //   Map<String, Integer> sqlResults = executeSQLBrowseQuery(sql);
                //  Map<String, Integer> cqlResults = executeCQLBrowseQuery(cql, p.getProperty("queries." + i + ".cql.groupBy"));

                // TODO compare and update report
            }
        }

        log.info("Generated report : " + report.toString());
        return report;
    }


    @Transactional
    public void promoteShadowSchema() throws Exception {

        promoteShadowCache();
        Connection con = dataSource.getConnection();

        log.info("Replacing public schema  with shadow in " + dataSource.getConnection().getMetaData().getURL() + " ...");
        con.createStatement().execute(" DROP SCHEMA public CASCADE ; ");
        con.createStatement().execute("ALTER SCHEMA shadow RENAME TO public ;");

        // alter schema ownership to dnet so that the portal user can see it
        // log.info("Setting schema owner to Portal User..");
        //  con.createStatement().execute("ALTER SCHEMA public OWNER TO " + portalUser + " ;");

        log.info("All ops done!");
        con.close();


    }

    public void refreshCache() throws Exception {
        executeRemoteScript(refreshShadowCacheURL);
        log.info("refreshCache done!");

    }

    public void promoteShadowCache() throws Exception {
        try {


            executeRemoteScript(this.promoteShadowCacheURL);

        } catch (Exception e) {
            log.error("Error while calling php script to Replaced Shadow Cache Entries with Public. Reason: " + e);
            throw new Exception(e);
        }
    }

    private void executeRemoteScript(URL url) throws Exception {
        try {
            //TODO remove loggeer
            //BasicConfigurator.configure();


            Base64Converter converter = new Base64Converter();
            BufferedReader in = null;

            // httpsUsername = "eri.katsari";
            //httpsPassword = "UDxG2ydA";
            // promoteShadowCacheURL = new URL("https://test.openaire.eu/stats/promoteShadow.php");


            if (url.toString().startsWith("https://")) {

                String credentials = this.httpsUsername + ":" + this.httpsPassword;
                String encoding = converter.encode(credentials.getBytes("UTF-8"));


                log.info("Using https : " + url.toString());
                HttpsURLConnection yc = (HttpsURLConnection) url.openConnection();

                yc.setRequestProperty("Authorization", String.format("Basic %s", encoding));
                in = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));
            } else {
                log.info("Using normal url : " + url.toString());
                URLConnection yc = (URLConnection) url.openConnection();

                in = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));

            }

            String inputLine;

            while ((inputLine = in.readLine()) != null)
                log.info(inputLine);


            in.close();


        } catch (Exception e) {
            log.error("Error while calling php script over http. Reason: " + e);
            throw new Exception(e);
        }
    }


    private boolean validate(int sqlResult, int cqlResult) {

        log.info(" Validation input " + sqlResult + " " + cqlResult);
        if (sqlResult == cqlResult) {

            return true;
        }

        return false;
    }

    private Map<String, Integer> executeCQLBrowseQuery(String cql, String groupBy) {
        // TODO implement me please

        //oaftype=result and deletedbyinferece=false and type=publication , groupby = access_mode
        // searchServiceServiceLocator.getService().refine();

        //public SearchResult refine(String queryText, String transformer,
        //String locale, Collection<String> fields) throws SearchServiceException;

        //    public SearchResult refine(String queryText, String transformer,
        //          String locale, Collection<String> fields) throws SearchServiceException;
        //[2:52:39 PM] Antonis Lempesis:


        //query=   oaftype=result and deletedbyinferece=false and type=publication

        //transformer = results_openaire

//        locale=UTF-8

        //      fields = access_mode


//        set to 1 page and results
        //       public SearchResult search(String queryText, String transformer,
        //             String locale, int page, int size) throws SearchServiceException;

        throw new UnimplementedException();
    }

    private Map<String, Integer> executeSQLBrowseQuery(String sql) {
        // TODO implement me please
        throw new UnimplementedException();
    }

    private int executeCQLCountQuery(String cql) throws Exception {
        try {
            if (cql == null || cql.isEmpty() || cql.equalsIgnoreCase("not available")) {
                return 0;
            }
            SearchResult result = searchWebService.search(cql, "results_openaire", "en_GB", 1, 1);

            return result.getTotal();


        } catch (Exception e) {
            log.error("Could not execute CQL query. Reason: " + e);
            throw new Exception("Could not execute CQL query. Reason: ", e);
        }
    }


    public void printLongerTrace(Throwable t) {
        for (StackTraceElement e : t.getStackTrace())
            System.out.println(e);

    }


    private int executeSQLCountQuery(String sql) throws Exception {

        Connection con = null;
        try {

            con = dataSource.getConnection();

            log.info("Preparing report for " + con.getMetaData().getURL());
            log.info("Executing Sql query  " + sql);

            Statement st = con.createStatement();
            if (st.execute(sql)) {

                ResultSet rs = st.getResultSet();
                int res = getResult(rs);
                st.close();
                return res;
            } else {
                log.error("Fail to execute command  " + sql + "  " + st.getWarnings());
                throw new Exception("Fail to execute command " + sql + "  " + st.getWarnings());
            }


        } catch (Exception e) {
            log.error("Could not execute sql query  " + sql + " : " + e);
            throw new Exception("Could not execute sql query  " + sql + " : ", e);
        } finally {
            if (con != null) {
                con.close();


            }
        }

    }

    private int getResult(ResultSet rs) throws Exception {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        int res = -1;
        try {

            ResultSetMetaData rsmd = rs.getMetaData();

            if (rs.next()) {
                log.info("Query result : " + rsmd.getColumnName(1) + rs.getObject(1));
                res = (Integer.valueOf(rs.getString(1)));
                rs.close();
            }

            return res;
        } catch (Exception e) {
            log.error("Could not process results :" + e);
            throw new Exception("Could not process results :", e);
        }

    }

    private HashMap<String, Integer> getResults(ResultSet rs) throws Exception {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        try {

            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                for (int i = 1; i < rsmd.getColumnCount() - 1; i++) {
                    data.put(rsmd.getColumnName(i), rs.getInt(i));
                }

            }

            return data;

        } catch (Exception e) {
            log.error("Could not process results :" + e);
            throw new Exception("Could not process results :", e);
        }

    }


    public Resource getValidationQueriesFile() {
        return validationQueriesFile;


    }

    public void setValidationQueriesFile(Resource validationQueriesFile) {
        this.validationQueriesFile = validationQueriesFile;
    }

    public URL getRefreshShadowCacheURL() {
        return refreshShadowCacheURL;
    }

    public void setRefreshShadowCacheURL(URL refreshShadowCacheURL) {
        this.refreshShadowCacheURL = refreshShadowCacheURL;
    }

    public URL getPromoteShadowCacheURL() {
        return promoteShadowCacheURL;
    }

    public void setPromoteShadowCacheURL(URL promoteShadowCacheURL) {
        this.promoteShadowCacheURL = promoteShadowCacheURL;
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }


    public ValidationReport getValidationReport() {
        return validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public String getPortalUser() {
        return portalUser;
    }

    public void setPortalUser(String portalUser) {
        this.portalUser = portalUser;
    }


    public Logger getLog() {
        return log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public String getShadowSearchURL() {
        return shadowSearchURL;
    }

    public void setShadowSearchURL(String shadowSearchURL) {
        this.shadowSearchURL = shadowSearchURL;
    }

    public static SearchWebService getSearchWebService() {
        return searchWebService;
    }

    public static void setSearchWebService(SearchWebService searchWebService) {
        StatsManager.searchWebService = searchWebService;
    }

    public String getHttpsUsername() {
        return httpsUsername;
    }

    public void setHttpsUsername(String httpsUsername) {
        this.httpsUsername = httpsUsername;
    }

    public String getHttpsPassword() {
        return httpsPassword;
    }

    public void setHttpsPassword(String httpsPassword) {
        this.httpsPassword = httpsPassword;
    }
}
