package eu.dnetlib.data.statsmanager;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.log4j.Logger;

import javax.xml.bind.JAXBContext;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Created by antleb on 10/25/14.
 */
public class StatsManagerServiceBlackboardHandler extends BlackboardNotificationHandler<BlackboardServerHandler> {

    private static Logger logger = Logger.getLogger(StatsManagerServiceBlackboardHandler.class);
    private StatsManager statsManager;

    protected void processJob(BlackboardJob job) {
        //TODO needs this?
        super.processJob(job);

        logger.info("Beginning new job...");
        logger.info("Id: " + job.getId() + " Date : " + job.getDate());
        String action = job.getAction();

        logger.info("Got BB message: " + action);

        try {
            getBlackboardHandler().ongoing(job);

            if (action.equals("validate")) {
                ValidationReport report = statsManager.validateDatabase();

                // TODO update job status
                StringWriter sw = new StringWriter();
                JAXBContext.newInstance(ValidationReport.class).createMarshaller().marshal(report, sw);

                job.getParameters().put("report", sw.toString());
            } else if (action.equals("refreshCache")) {
                statsManager.refreshCache();
            } else if (action.equals("refreshNums")) {
                //statsManager.promoteShadowSchema();
            } else if (action.equals("refreshCharts")) {
                //statsManager.promoteShadowSchema();
            } else if (action.equals("promoteShadow")) {
                statsManager.promoteShadowSchema();
            } else if (action.equals("promoteShadowCache")) {
                statsManager.promoteShadowCache();
            } else if (action.equals("'promoteNums")) {
                // statsManager.promoteShadowCache();
            } else if (action.equals("promoteCharts")) {
                // statsManager.promoteShadowCache();
            } else if (action.equals("promoteShadowCache")) {
                //statsManager.promoteShadowCache();
            } else if (action.equals("restore")) {
                statsManager.promoteShadowCache();
            } else if (action.equals("backup")) {
                statsManager.promoteShadowCache();
            } else if (action.equals("migrate")) {
                statsManager.promoteShadowCache();
            } else {
                throw new Exception("Don't know what to do with " + action);
            }

            getBlackboardHandler().done(job);
        } catch (
                Exception e
                )

        {
            getBlackboardHandler().failed(job, e);

            logger.error("Error processing job", e);
        }

    }


    public StatsManager getStatsManager() {
        return statsManager;
    }

    public void setStatsManager(StatsManager statsManager) {
        this.statsManager = statsManager;
    }
}
