/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.Base64Converter;

public class CacheController {
    private HashMap<String, URL> actions;
    private String httpsUsername;
    private String httpsPassword;
    private Logger log = Logger.getLogger(this.getClass());

    public CacheController() {
    }

    public void refreshCache() throws Exception {
        this.executeRemoteScript(this.getActions().get("refreshAll"));
    }

    public void refreshNums() throws Exception {
        this.log.info((Object)this.getActions().get("refreshNums"));
        this.log.info((Object)"CacheController : Now refreshing nums...");
        this.executeRemoteScript(this.getActions().get("refreshNums"));
    }

    public void refreshCharts() throws Exception {
        this.executeRemoteScript(this.getActions().get("refreshCharts"));
    }

    public void promoteCharts() throws Exception {
        this.executeRemoteScript(this.getActions().get("promoteCharts"));
    }

    public void promoteNums() throws Exception {
        this.executeRemoteScript(this.getActions().get("promoteNums"));
    }

    public void promoteCache() throws Exception {
        this.executeRemoteScript(this.getActions().get("promoteAll"));
    }

    public void backup() throws Exception {
        this.executeRemoteScript(this.getActions().get("backup"));
    }

    public void migrate() throws Exception {
        this.executeRemoteScript(this.getActions().get("migrate"));
    }

    public void restore() throws Exception {
        this.executeRemoteScript(this.getActions().get("restore"));
    }

    private void executeRemoteScript(URL url) throws Exception {
        try {
            String inputLine;
            Base64Converter converter = new Base64Converter();
            BufferedReader in = null;
            if (url.toString().startsWith("https://")) {
                String credentials = this.httpsUsername + ":" + this.httpsPassword;
                String encoding = converter.encode(credentials.getBytes("UTF-8"));
                this.log.info((Object)("Using https : " + url.toString()));
                HttpsURLConnection yc = (HttpsURLConnection)url.openConnection();
                yc.setRequestProperty("Authorization", String.format("Basic %s", encoding));
                in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            } else {
                this.log.info((Object)("Using normal url : " + url.toString()));
                URLConnection yc = url.openConnection();
                in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            }
            while ((inputLine = in.readLine()) != null) {
                this.log.info((Object)inputLine);
            }
            in.close();
        }
        catch (Exception e) {
            this.log.error((Object)("Error while calling php script over http. Reason: " + e));
            throw new Exception(e);
        }
    }

    public HashMap<String, URL> getActions() {
        return this.actions;
    }

    public void setActions(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public CacheController(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public String getHttpsUsername() {
        return this.httpsUsername;
    }

    public void setHttpsUsername(String httpsUsername) {
        this.httpsUsername = httpsUsername;
    }

    public String getHttpsPassword() {
        return this.httpsPassword;
    }

    public void setHttpsPassword(String httpsPassword) {
        this.httpsPassword = httpsPassword;
    }
}

