/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import eu.dnetlib.data.statsmanager.StatsManager;
import eu.dnetlib.data.statsmanager.ValidationReport;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import org.apache.log4j.Logger;

public class StatsManagerServiceBlackboardHandler
extends BlackboardNotificationHandler<BlackboardServerHandler> {
    private static Logger logger = Logger.getLogger(StatsManagerServiceBlackboardHandler.class);
    private StatsManager statsManager;

    protected void processJob(BlackboardJob job) {
        super.processJob(job);
        logger.info((Object)"Beginning new job...");
        logger.info((Object)("Id: " + job.getId() + " Date : " + job.getDate()));
        String action = job.getAction();
        logger.info((Object)("Got BB message: " + action));
        try {
            ((BlackboardServerHandler)this.getBlackboardHandler()).ongoing(job);
            if (action.equals("validate")) {
                ValidationReport report = this.statsManager.validateDatabase();
                StringWriter sw = new StringWriter();
                JAXBContext.newInstance((Class[])new Class[]{ValidationReport.class}).createMarshaller().marshal((Object)report, (Writer)sw);
                job.getParameters().put("report", sw.toString());
            } else if (action.equals("refreshCache")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("refreshNums")) {
                logger.info((Object)"Now refreshing nums...");
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("refreshCharts")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("promoteShadow")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("promoteNums")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("promoteCharts")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("promoteCache")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("restore")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("backup")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("migrate")) {
                this.statsManager.executeCacheAction(action);
            } else if (action.equals("updateDBPath")) {
                this.statsManager.updateDBPath((String)job.getParameters().get("dbUrl"));
            } else {
                throw new Exception("Don't know what to do with " + action);
            }
            ((BlackboardServerHandler)this.getBlackboardHandler()).done(job);
        }
        catch (Exception e) {
            ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, (Throwable)e);
            logger.error((Object)"Error processing job", (Throwable)e);
        }
    }

    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    public void setStatsManager(StatsManager statsManager) {
        this.statsManager = statsManager;
    }
}

