/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import eu.dnetlib.clients.data.search.ws.SearchWebService;
import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.data.statsmanager.ValidationReport;
import eu.dnetlib.domain.data.SearchResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

public class Validator {
    private ValidationReport validationReport;
    private Resource validationQueriesFile;
    private DataSource dataSource;
    private String shadowSearchURL;
    private static SearchWebService searchWebService = null;
    private Logger log = Logger.getLogger(this.getClass());

    private void initSearch() {
        if (searchWebService == null) {
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setServiceClass(SearchWebService.class);
            factory.setAddress(this.shadowSearchURL);
            searchWebService = (SearchWebService)factory.create();
        }
    }

    public ValidationReport validateDatabase() throws Exception {
        ValidationReport report = new ValidationReport();
        Properties p = new Properties();
        this.validationReport = report;
        try {
            this.initSearch();
            this.log.info((Object)("Search Client  initiated at " + this.shadowSearchURL));
        }
        catch (Exception e) {
            this.log.error((Object)e.toString());
            throw new Exception(e);
        }
        try {
            p.loadFromXML(this.validationQueriesFile.getInputStream());
        }
        catch (Exception e) {
            this.log.error((Object)("Error while loading queries file :" + e.toString()));
            throw new Exception(e);
        }
        int queryCount = Integer.parseInt(p.getProperty("queries.count"));
        this.log.info((Object)("Query  Count: " + queryCount + "\n"));
        for (int i = 1; i <= queryCount; ++i) {
            String queryType = p.getProperty("queries." + i + ".type");
            String sql = p.getProperty("queries." + i + ".sql");
            String cql = p.getProperty("queries." + i + ".cql.query");
            String name = p.getProperty("queries." + i + ".name");
            this.log.info((Object)("Query: " + name + "\n" + " SQL " + sql + "\n" + "CQL" + cql + "\n"));
            if (queryType.equals("search")) {
                int sqlResult = this.executeSQLCountQuery(sql);
                int cqlResult = this.executeCQLCountQuery(cql);
                boolean status = this.validate(sqlResult, cqlResult);
                this.validationReport.addQuery(name, sqlResult, cqlResult, status);
                continue;
            }
            if (!queryType.equals("browse")) continue;
        }
        this.log.info((Object)("Generated report : " + report.toString()));
        return report;
    }

    private boolean validate(int sqlResult, int cqlResult) {
        this.log.info((Object)(" Validation input " + sqlResult + " " + cqlResult));
        return sqlResult == cqlResult;
    }

    private Map<String, Integer> executeCQLBrowseQuery(String cql, String groupBy) {
        throw new UnimplementedException();
    }

    private Map<String, Integer> executeSQLBrowseQuery(String sql) {
        throw new UnimplementedException();
    }

    private int executeCQLCountQuery(String cql) throws Exception {
        try {
            if (cql == null || cql.isEmpty() || cql.equalsIgnoreCase("not available")) {
                return 0;
            }
            SearchResult result = searchWebService.search(cql, "results_openaire", "en_GB", 1, 1);
            return result.getTotal();
        }
        catch (Exception e) {
            this.log.error((Object)("Could not execute CQL query. Reason: " + e));
            throw new Exception("Could not execute CQL query. Reason: ", e);
        }
    }

    private int executeSQLCountQuery(String sql) throws Exception {
        try (Connection con = null;){
            con = this.dataSource.getConnection();
            this.log.info((Object)("Preparing report for " + con.getMetaData().getURL()));
            this.log.info((Object)("Executing Sql query  " + sql));
            Statement st = con.createStatement();
            if (st.execute(sql)) {
                ResultSet rs = st.getResultSet();
                int res = this.getResult(rs);
                st.close();
                int n = res;
                return n;
            }
            try {
                this.log.error((Object)("Fail to execute command  " + sql + "  " + st.getWarnings()));
                throw new Exception("Fail to execute command " + sql + "  " + st.getWarnings());
            }
            catch (Exception e) {
                this.log.error((Object)("Could not execute sql query  " + sql + " : " + e));
                throw new Exception("Could not execute sql query  " + sql + " : ", e);
            }
        }
    }

    private int getResult(ResultSet rs) throws Exception {
        HashMap data = new HashMap();
        int res = -1;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next()) {
                this.log.info((Object)("Query result : " + rsmd.getColumnName(1) + rs.getObject(1)));
                res = Integer.valueOf(rs.getString(1));
                rs.close();
            }
            return res;
        }
        catch (Exception e) {
            this.log.error((Object)("Could not process results :" + e));
            throw new Exception("Could not process results :", e);
        }
    }

    private HashMap<String, Integer> getResults(ResultSet rs) throws Exception {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                for (int i = 1; i < rsmd.getColumnCount() - 1; ++i) {
                    data.put(rsmd.getColumnName(i), rs.getInt(i));
                }
            }
            return data;
        }
        catch (Exception e) {
            this.log.error((Object)("Could not process results :" + e));
            throw new Exception("Could not process results :", e);
        }
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public Resource getValidationQueriesFile() {
        return this.validationQueriesFile;
    }

    public void setValidationQueriesFile(Resource validationQueriesFile) {
        this.validationQueriesFile = validationQueriesFile;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getShadowSearchURL() {
        return this.shadowSearchURL;
    }

    public void setShadowSearchURL(String shadowSearchURL) {
        this.shadowSearchURL = shadowSearchURL;
    }
}

