package eu.dnetlib.data.statsmanager;


import org.apache.log4j.Logger;
import org.apache.tools.ant.util.Base64Converter;

import javax.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;


public class CacheController {

    private HashMap<String, URL> actions;
    private String httpsUsername;
    private String httpsPassword;
    private Logger log = Logger.getLogger(this.getClass());

    public CacheController() {

    }

    public void refreshCache() throws Exception {
        executeRemoteScript(this.getActions().get("refreshAll"));

    }

    public void refreshNums() throws Exception {

        log.info(this.getActions().get("refreshNums"));
        log.info("CacheController : Now refreshing nums...");
        executeRemoteScript(this.getActions().get("refreshNums"));
    }

    public void refreshCharts() throws Exception {
        executeRemoteScript(this.getActions().get("refreshCharts"));
    }

    public void promoteCharts() throws Exception {
        executeRemoteScript(this.getActions().get("promoteCharts"));
    }

    public void promoteNums() throws Exception {
        executeRemoteScript(this.getActions().get("promoteNums"));
    }

    public void promoteCache() throws Exception {
        executeRemoteScript(this.getActions().get("promoteAll"));
    }

    public void backup() throws Exception {
        executeRemoteScript(this.getActions().get("backup"));
    }

    public void migrate() throws Exception {
        executeRemoteScript(this.getActions().get("migrate"));
    }


    public void restore() throws Exception {
        executeRemoteScript(this.getActions().get("restore"));
    }


    private void executeRemoteScript(URL url) throws Exception {
        try {


            Base64Converter converter = new Base64Converter();
            BufferedReader in = null;
            if (url.toString().startsWith("https://")) {

                String credentials = this.httpsUsername + ":" + this.httpsPassword;
                String encoding = converter.encode(credentials.getBytes("UTF-8"));


                log.info("Using https : " + url.toString());
                HttpsURLConnection yc = (HttpsURLConnection) url.openConnection();

                yc.setRequestProperty("Authorization", String.format("Basic %s", encoding));
                in = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));
            } else {
                log.info("Using normal url : " + url.toString());
                URLConnection yc = (URLConnection) url.openConnection();

                in
                        = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));

            }

            String inputLine;

            while ((inputLine = in.readLine()) != null)
                log.info(inputLine);


            in.close();


        } catch (Exception e) {
            log.error("Error while calling php script over http. Reason: " + e);
            throw new Exception(e);
        }
    }


    public HashMap<String, URL> getActions() {
        return actions;
    }

    public void setActions(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public CacheController(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public String getHttpsUsername() {
        return httpsUsername;
    }

    public void setHttpsUsername(String httpsUsername) {
        this.httpsUsername = httpsUsername;
    }

    public String getHttpsPassword() {
        return httpsPassword;
    }

    public void setHttpsPassword(String httpsPassword) {
        this.httpsPassword = httpsPassword;
    }

}
