package eu.dnetlib.data.statsmanager;


import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.sql.Connection;

public class StatsManager {

    private Validator validator;

    private ValidationReport validationReport;

    private DataSource dataSource;

    private String portalUser;

    private CacheController cacheController;

    private Logger log = Logger.getLogger(this.getClass());

    public StatsManager() {


    }


    public ValidationReport validateDatabase() throws Exception {


        this.validationReport = validator.validateDatabase();
        return validationReport;
    }


    @Transactional
    public void promoteShadowSchema() throws Exception {
        Connection con = dataSource.getConnection();

        log.info("Backing up and Replacing public schema  with shadow in " + dataSource.getConnection().getMetaData().getURL() + " ...");
        con.createStatement().execute("drop schema if exists backup CASCADE ;");
        con.createStatement().execute("alter schema public rename to backup ;");
        con.createStatement().execute("alter schema  shadow rename TO public ;");
        log.info("All ops done!");
        con.close();
    }

    public void updateDBPath(String dbUrl) {
    }

    public void executeCacheAction(String action) throws Exception {

        if (action.equals("refreshCache")) {
            cacheController.refreshCache();
        } else if (action.equals("refreshCharts")) {
            cacheController.refreshCharts();
        } else if (action.equals("refreshNums")) {
            log.info("Now refreshing nums...");
            cacheController.refreshNums();
        } else if (action.equals("promoteShadow")) {
            cacheController.promoteCache();
            this.promoteShadowSchema();
        } else if (action.equals("promoteNums")) {
            cacheController.promoteNums();
        } else if (action.equals("promoteCharts")) {
            cacheController.promoteCharts();
        } else if (action.equals("promoteCache")) {
            cacheController.promoteCache();
        } else if (action.equals("restore")) {
            cacheController.restore();
        } else if (action.equals("migrate")) {
            cacheController.migrate();
        } else if (action.equals("backup")) {
            cacheController.backup();
        } else {
            log.error("Wrong action given ");

        }

    }


    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }


    public String getPortalUser() {
        return portalUser;
    }

    public void setPortalUser(String portalUser) {
        this.portalUser = portalUser;
    }


    public CacheController getCacheController() {
        return cacheController;
    }

    public void setCacheController(CacheController cacheController) {
        this.cacheController = cacheController;
    }

    public Validator getValidator() {
        return validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public ValidationReport getValidationReport() {
        return validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }
}
