/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.statsmanager;

import eu.dnetlib.data.statsmanager.CacheController;
import eu.dnetlib.data.statsmanager.ValidationReport;
import eu.dnetlib.data.statsmanager.Validator;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class StatsManager {
    private Validator validator;
    private ValidationReport validationReport;
    private DataSource dataSource;
    private String portalUser;
    private CacheController cacheController;
    private Logger log = Logger.getLogger(this.getClass());

    public ValidationReport validateDatabase() throws Exception {
        this.validationReport = this.validator.validateDatabase();
        return this.validationReport;
    }

    @Transactional
    public void promoteShadowSchema() throws Exception {
        Connection con = this.dataSource.getConnection();
        this.log.info((Object)("Backing up and Replacing public schema  with shadow in " + this.dataSource.getConnection().getMetaData().getURL() + " ..."));
        con.createStatement().execute("drop schema if exists backup CASCADE ;");
        con.createStatement().execute("alter schema public rename to backup ;");
        con.createStatement().execute("alter schema  shadow rename TO public ;");
        this.log.info((Object)"All ops done!");
        con.close();
    }

    public void updateDBPath(String dbUrl) {
    }

    public void executeCacheAction(String action) throws Exception {
        if (action.equals("refreshCache")) {
            this.cacheController.refreshCache();
        } else if (action.equals("refreshCharts")) {
            this.cacheController.refreshCharts();
        } else if (action.equals("refreshNums")) {
            this.log.info((Object)"Now refreshing nums...");
            this.cacheController.refreshNums();
        } else if (action.equals("promoteShadow")) {
            this.cacheController.promoteCache();
            this.promoteShadowSchema();
        } else if (action.equals("promoteNums")) {
            this.cacheController.promoteNums();
        } else if (action.equals("promoteCharts")) {
            this.cacheController.promoteCharts();
        } else if (action.equals("promoteCache")) {
            this.cacheController.promoteCache();
        } else if (action.equals("restore")) {
            this.cacheController.restore();
        } else if (action.equals("migrate")) {
            this.cacheController.migrate();
        } else if (action.equals("backup")) {
            this.cacheController.backup();
        } else {
            this.log.error((Object)"Wrong action given ");
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getPortalUser() {
        return this.portalUser;
    }

    public void setPortalUser(String portalUser) {
        this.portalUser = portalUser;
    }

    public CacheController getCacheController() {
        return this.cacheController;
    }

    public void setCacheController(CacheController cacheController) {
        this.cacheController = cacheController;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }
}

