package eu.dnetlib.data.statsmanager;


import org.apache.log4j.Logger;
import org.apache.tools.ant.util.Base64Converter;

import javax.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;


public class CacheController {

    private HashMap<String, URL> actions;
    private String httpsUsername;
    private String httpsPassword;
    private Logger log = Logger.getLogger(this.getClass());


    public CacheController() {
    }

    public void executeCommand(String cacheURL, String action,String username, String password) throws Exception {

        URL url;
        if (cacheURL != null && !cacheURL.isEmpty()) {
            log.debug("existing cache url " + this.getActions().get(action));
            String actionUrl = this.getActions().get(action).toString();
            actionUrl = actionUrl.substring(actionUrl.lastIndexOf("/"), actionUrl.length());
            url = new URL(cacheURL + actionUrl);

              executeRemoteScript(url,username,password);

        } else {
            url = this.actions.get(action);
            executeRemoteScript(url,httpsUsername,httpsPassword);
 
  }
}

    private void executeRemoteScript(URL url,String username, String pass) throws Exception {
        try {


            Base64Converter converter = new Base64Converter();
             BufferedReader in = null;

            if (url.toString().startsWith("https://")) {
            
               // pass= converter.decodeToString(pass);
                String credentials = username + ":" + pass;
                String encoding = converter.encode(credentials.getBytes("UTF-8"));

                log.info("Using https : " + url.toString());
                HttpsURLConnection yc = (HttpsURLConnection) url.openConnection();
                yc.setRequestProperty("Authorization", String.format("Basic %s", encoding));
                in = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));
            } else {
                log.info("Using normal url : " + url.toString());
                URLConnection yc = (URLConnection) url.openConnection();

                in
                        = new BufferedReader(
                        new InputStreamReader(
                                yc.getInputStream()));

            }

            String inputLine;

            while ((inputLine = in.readLine()) != null)
                log.info(inputLine);


            in.close();


        } catch (Exception e) {
            log.error("Error while calling php script over http. Reason: " + e);
            throw new Exception(e);
        }
    }

/*
    public updateCacheURL(String url)

    {
        HashMap<String, URL> newActions = new HashMap();

        for (Entry<String,URL> e: this.actions.entrySet()) {
            
newActions.put(e.getKey(),new URL (url+action));


        }

    }
*/
    public HashMap<String, URL> getActions() {
        return actions;
    }

    public void setActions(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public CacheController(HashMap<String, URL> actions) {
        this.actions = actions;
    }

    public String getHttpsUsername() {
        return httpsUsername;
    }

    public void setHttpsUsername(String httpsUsername) {
        this.httpsUsername = httpsUsername;
    }

    public String getHttpsPassword() {
        return httpsPassword;
    }

    public void setHttpsPassword(String httpsPassword) {
        this.httpsPassword = httpsPassword;
    }

}
