package eu.dnetlib.data.statsmanager;

import org.apache.log4j.Logger;

import javax.xml.bind.annotation.XmlRootElement;


@XmlRootElement(name = "Query")
public class Query {

    private String name;
    private int dbResult;
    private int cqlResult;
    private statusFlag status;

    private Logger log = Logger.getLogger(this.getClass());

    public Query() {
    };

    public Query(String key, Integer dbResult, int cqlResult, boolean qStatus) {
        this.name = key;
        this.dbResult = dbResult;
        this.cqlResult = cqlResult;
        if (qStatus) {
            this.status = statusFlag.success;

        } else {
            this.status = statusFlag.fail;
        }

        log.debug("Created Query: " + this.toString());
    }

    public enum statusFlag {success, fail}


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "Query{" +
                "name='" + name + '\'' +
                ", dbResult=" + dbResult +
                ", cqlResult=" + cqlResult +
                ", status=" + status +
                '}';
    }

    public int getDbResult() {
        return dbResult;
    }

    public void setDbResult(int dbResult) {
        this.dbResult = dbResult;
    }

    public int getCqlResult() {
        return cqlResult;
    }

    public void setCqlResult(int cqlResult) {
        this.cqlResult = cqlResult;
    }
}
