package eu.dnetlib.data.statsmanager;


import org.apache.log4j.Logger;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.sql.Connection;

public class StatsManager {

    private Validator validator;

    private ValidationReport validationReport;

    private DataSource dataSource;

    private String portalUser;

    private CacheController cacheController;

    private Logger log = Logger.getLogger(this.getClass());

    public StatsManager() {
 
    }


    public ValidationReport validateDatabase() throws Exception {


        this.validationReport = validator.validateDatabase();
        return validationReport;
    }


    @Transactional
    public void promoteShadowSchema() throws Exception {
        Connection con = dataSource.getConnection();

        log.info("Backing up and Replacing public schema  with shadow in " + dataSource.getConnection().getMetaData().getURL() + " ...");
        con.createStatement().execute("drop schema if exists backup CASCADE ;");
        con.createStatement().execute("alter schema public rename to backup ;");
        con.createStatement().execute("alter schema  shadow rename TO public ;");
        log.info("All ops done!");
        con.close();
    }

    public void updateDBPath(String dbUrl) {
    }

    public void executeCacheAction(BlackboardJob job) throws Exception {

        if (job.getAction().equals("refreshCache")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), "refreshAll",job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("refreshCharts")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("refreshNums")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("promoteShadow")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), "promoteAll",job.getParameters().get("username"),job.getParameters().get("password"));
            this.promoteShadowSchema();
        } else if (job.getAction().equals("promoteNums")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("promoteCharts")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("promoteCache")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), "promoteAll",job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("restore")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("migrate")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));
        } else if (job.getAction().equals("backup")) {
            log.info("Executing " + job.getAction() + "...");
            cacheController.executeCommand(job.getParameters().get("cacheURL"), job.getAction(),job.getParameters().get("username"),job.getParameters().get("password"));

        }
 /* else if (job.getAction().equals("updateCacheURL"))
         {
            log.info("Executing " + job.getAction() + "...");
            cacheController.updateCacheURL(job.getParameters().get("cacheURL"));
        }*/
        else {
            log.error("Wrong action given ");
            throw new Exception("Wrong action given ");
        }

    }


    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }


    public String getPortalUser() {
        return portalUser;
    }

    public void setPortalUser(String portalUser) {
        this.portalUser = portalUser;
    }


    public CacheController getCacheController() {
        return cacheController;
    }

    public void setCacheController(CacheController cacheController) {
        this.cacheController = cacheController;
    }

    public Validator getValidator() {
        return validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public ValidationReport getValidationReport() {
        return validationReport;
    }

    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }
}
