package eu.dnetlib.data.statsmanager;


import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import java.io.IOException;

/**
 * Created by antleb on 10/25/14.
 */
@Controller
public class StatsManagerController {

    private StatsManager statsManager;

    @RequestMapping(value = "/stats", method = RequestMethod.GET)
    public void getReport(HttpServletRequest request, HttpServletResponse response) throws IOException, JAXBException {
        ValidationReport report = statsManager.getValidationReport();

        JAXBContext.newInstance().createMarshaller().marshal(report, response.getWriter());
    }

    public StatsManager getStatsManager() {
        return statsManager;
    }

    public void setStatsManager(StatsManager statsManager) {
        this.statsManager = statsManager;
    }
}
