package eu.dnetlib.openaire.user.dao;

import eu.dnetlib.openaire.user.User;
import eu.dnetlib.openaire.user.store.Statement;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;


/**
 * Created by sofia on 24/6/2016.
 */
public interface UserDAO {

    List<User> fetchAll();

    User fetchById(String id);
    User fetchByEmail(String mail);
    User fetchByUsername(String username);
    User fetchByName(String name);
    User fetchBySurname(String surname);

    int countAll();

    void insert(User u);
    void delete (User u);
    User update(User u);

    User fromResultSet(ResultSet set) throws SQLException;

    int executeUpdate(String sql);
    int executeUpdate(String sql, Statement.Initializer init);

    User executeQuery(String sql);
    User executeQuery(String sql, Statement.Initializer init);

    long executeCount(String sql);
    long executeCount(String sql, Statement.Initializer init);


}