package eu.dnetlib.openaire.user.ldap;

import com.unboundid.util.Base64;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Random;

/**
 * Created by sofia on 31/10/2016.
 */
public class Joomla15PasswordHash {

    public static boolean check(String passwd,String dbEntry) {
        String hashed = "{MD5}"+ Base64.encode(pack(Joomla15PasswordHash.md5(passwd)));
        if(dbEntry.equals(hashed))
            return true;
        else
            return false;
    }

    static Random _rnd;

    public static String create(String passwd) {
        return "{MD5}"+Base64.encode(pack(Joomla15PasswordHash.md5(passwd)));
    }

    /** Takes the MD5 hash of a sequence of ASCII or LATIN1 characters,
     *  and returns it as a 32-character lowercase hex string.
     *
     *  Equivalent to MySQL's MD5() function
     *  and to perl's Digest::MD5::md5_hex(),
     *  and to PHP's md5().
     *
     *  Does no error-checking of the input,  but only uses the low 8 bits
     *  from each input character.
     */
    public static String md5(String data) {
        byte[] bdata = new byte[data.length()]; int i; byte[] hash;

        for (i=0;i<data.length();i++) bdata[i]=(byte)(data.charAt(i)&0xff );

        try {
            MessageDigest md5er = MessageDigest.getInstance("MD5");
            hash = md5er.digest(bdata);
        } catch (GeneralSecurityException e) { throw new RuntimeException(e); }

        StringBuffer r = new StringBuffer(32);
        for (i=0;i<hash.length;i++) {
            String x = Integer.toHexString(hash[i]&0xff);
            if (x.length()<2) r.append("0");
            r.append(x);
        }
        return r.toString();
    }

    public static byte[] pack(String md5) {
        byte[] bytes = new byte[16];
        int j = 0;
        for(int i=0; i < 31; i+=2) {
            bytes[j] = (byte) Integer.parseInt(md5.charAt(i)+""+md5.charAt(i+1),16);
            j++;
        }
        return bytes;
    }
}
