package eu.dnetlib.openaire.user.queries;

/**
 * Created by sofia on 1/11/2016.
 */
public interface SQLMigrationUserQueries {

    // Queries (as prepared statements to avoid SQL-injection)
    String FETCH_ALL         = "SELECT * FROM users";
    String FETCH_BY_ID       = "SELECT * FROM users WHERE id = ?";
    String FETCH_BY_USERNAME = "SELECT * FROM users WHERE username = ?";
    String FETCH_BY_FULLNAME = "SELECT * FROM users WHERE fullname = ?";
    String FETCH_BY_EMAIL    = "SELECT * FROM users WHERE email = ?";
    String FETCH_BY_ROLE_ID  = "SELECT * FROM users WHERE role_id = ?";

    String COUNT_ALL = "SELECT COUNT(*) FROM users";

    String INSERT = "INSERT INTO users (" +
            "username, " +
            "fullname, " +
            "email, " +
            "role_id" +
            ") VALUES (?,?,?,?)";

    String UPDATE = "UPDATE users SET " +
            "username = ?, " +
            "fullname = ?, " +
            "email = ?, " +
            "role_id = ? " +
            "WHERE id = ?";

    String DELETE = "DELETE FROM users WHERE id = ?";
}
