package eu.dnetlib.openaire.user.security;

import eu.dnetlib.openaire.user.MigrationUser;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import java.util.Date;

/**
 * Created by kiatrop on 03/04/17.
 */
public class JWTGenerator {

    public static String generateToken(MigrationUser u, String secret) {
        Claims claims = Jwts.claims().setSubject(u.getUsername());
        claims.put("fullname", u.getFullname() + "");
        claims.put("userId", u.getId() + "");
        claims.put("email", u.getEmail() + "");
        claims.put("role", u.getRoleId());

        //expiration
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        long ttlMillis = 1800000;
        long expMillis = nowMillis + ttlMillis;
        Date exp = new Date(expMillis);

        return Jwts.builder()
                .setClaims(claims)
                .setExpiration(exp)
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
    }
}

// How to add it manually
//        long nowMillis = System.currentTimeMillis();
//        //This is my token
//        try {
//            String jwt = Jwts.builder()
//                    .setSubject("Argiro")
//                    .setExpiration(new Date(nowMillis+1800000))
//                    .claim("fullname", "Argiro Kokogianaki")
//                    .claim("id", "8")
//                    .claim("email", "argiro@gmail.com")
//                    .claim("role","2")
//                    .signWith(
//                            SignatureAlgorithm.HS512,
//                            "my-very-secret".getBytes("UTF-8")
//                    )
//                    .compact();
