package eu.dnetlib.openaire.user.store;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * Created by sofia on 31/10/2016.
 */
public class DataSourceConnector {

    private String username;
    private String password;
    private String dbUrl;
    private String driver;

    private static boolean driverLoad = false;
    private DataSource datasource;

    private static final Logger logger = Logger.getLogger(DataSourceConnector.class);

    public void init() {
        logger.info("Initializing data source");

        try {
            Class.forName(driver);
            driverLoad = true;

            BasicDataSource bds = new BasicDataSource();

            bds.setDriverClassName(driver);
            bds.setUrl(dbUrl);
            bds.setUsername(username);
            bds.setPassword(password);
            bds.setMaxIdle(10);
            bds.setMaxActive(100);
            bds.setMaxWait(10000);
            bds.setValidationQuery("select 1");
            bds.setTestOnBorrow(true);
            bds.setTestWhileIdle(true);
            bds.setTimeBetweenEvictionRunsMillis(1200000);
            bds.setMinEvictableIdleTimeMillis(1800000);
            bds.setNumTestsPerEvictionRun(5);
            bds.setDefaultAutoCommit(true);

            this.datasource = bds;

            // Test Connection
            getConnection().close();

            logger.info("Datasource " + datasource);
            logger.info(datasource.getConnection());

        } catch (ClassNotFoundException | SQLException exc) {
            logger.error("Unable to connenct to the DB. ", exc);
            throw new RuntimeException(exc);
        }
    }

    public Connection getConnection() throws SQLException {
        logger.debug("dbUrl " + dbUrl);
        return DriverManager.getConnection(dbUrl, username, password);
        //return DriverManager.getConnection("jdbc:postgresql://localhost:5433/MigrationUser?user=postgres&password=mypassword");
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbUrl() {
        return dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDriver() {
        return driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public DataSource getDatasource() {
        return datasource;
    }
}
