package eu.dnetlib.utils;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.ServiceIdentity;

public class ServiceIdentityFactory {
	private static Logger logger = Logger.getLogger(ServiceIdentityFactory.class);

	/**
	 * Reads a properties file with the name <serviceName>.properties from the
	 * classpath and returns a ServiceIdentity object that describes a service's
	 * version.
	 * @param serviceName the serviceName
	 * @return the service version.
	 */
	public static ServiceIdentity createIdentity(String serviceName) {
		try {
			Properties properties = new Properties();

			properties.load(ServiceIdentityFactory.class.getClassLoader()
					.getResourceAsStream(serviceName + ".properties"));

			String name = properties.getProperty("name");
			String label = properties.getProperty("label");
			String version[] = properties.getProperty("version").split("\\.");
			String major = version.length > 0?version[0]:null;
			String minor = version.length > 1?version[1]:null;
			String micro = version.length > 2?version[2]:null;
			
			return new ServiceIdentity(name, major, minor, micro, label);
		} catch (IOException e) {
			logger.error("Error creating service identity", e);
			
			return null;
		}
	}
	
	/**
	 * Parse a service version. Version syntax:
	 * ${NAME}-${MAJOR}.${MINOR}.${MICRO}[-${LABEL}]
	 * @param identity The string representation
	 * @return the ServiceIdentity object
	 */
	public static ServiceIdentity parseIdentity(String identity) {
		Pattern p = Pattern.compile("(.+)-(\\d)\\.(\\d)\\.(\\d)(-(.*))?");	
		Matcher m = p.matcher(identity);
		
		if (m.find()) {
			String name = m.group(1);
			String major = m.group(2);
			String minor = m.group(3);
			String micro = m.group(4);
			String label = m.group(6);
			
			return new ServiceIdentity(name, major, minor, micro, label);
		} else {
			return null;
		}
	}
	
}
