// $ANTLR 3.0.1 Cql.g3 2013-07-19 13:56:26

	package eu.dnetlib.utils.cql;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


import org.antlr.runtime.tree.*;

public class CqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AND", "OR", "NOT", "PROX", "WITHIN", "EXACT", "ALL", "ANY", "IDENTIFIER", "STRING", "QUOTE", "WHITESPACE", "'>'", "'='", "'/'", "'('", "')'", "'<'", "'>='", "'<='", "'<>'"
    };
    public static final int QUOTE=14;
    public static final int ANY=11;
    public static final int IDENTIFIER=12;
    public static final int ALL=10;
    public static final int OR=5;
    public static final int WITHIN=8;
    public static final int PROX=7;
    public static final int WHITESPACE=15;
    public static final int EXACT=9;
    public static final int NOT=6;
    public static final int AND=4;
    public static final int EOF=-1;
    public static final int STRING=13;

        public CqlParser(TokenStream input) {
            super(input);
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return tokenNames; }
    public String getGrammarFileName() { return "Cql.g3"; }


      @Override
      public void reportError(RecognitionException e) {
        throw new CqlRuntimeException("Parser Error", e);
      }


    public static class cql_return extends ParserRuleReturnScope {
        public CqlQuery query;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start cql
    // Cql.g3:33:1: cql returns [CqlQuery query] : q= cqlquery ;
    public final cql_return cql() throws RecognitionException {
        cql_return retval = new cql_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        cqlquery_return q = null;



        try {
            // Cql.g3:33:30: (q= cqlquery )
            // Cql.g3:33:32: q= cqlquery
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_cqlquery_in_cql78);
            q=cqlquery();
            _fsp--;

            adaptor.addChild(root_0, q.getTree());

            						//System.out.println("query tree: " +
            						//		((CommonTree)q.tree).toStringTree() );
            						retval.query = q.query;
            					

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end cql

    public static class cqlquery_return extends ParserRuleReturnScope {
        public CqlQuery query;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start cqlquery
    // Cql.g3:41:1: cqlquery returns [CqlQuery query] : ( qscope q= cqlquery | c= scopedClause );
    public final cqlquery_return cqlquery() throws RecognitionException {
        cqlquery_return retval = new cqlquery_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        cqlquery_return q = null;

        scopedClause_return c = null;

        qscope_return qscope1 = null;



        try {
            // Cql.g3:42:5: ( qscope q= cqlquery | c= scopedClause )
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==16) ) {
                alt1=1;
            }
            else if ( ((LA1_0>=AND && LA1_0<=PROX)||(LA1_0>=IDENTIFIER && LA1_0<=STRING)||LA1_0==19) ) {
                alt1=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("41:1: cqlquery returns [CqlQuery query] : ( qscope q= cqlquery | c= scopedClause );", 1, 0, input);

                throw nvae;
            }
            switch (alt1) {
                case 1 :
                    // Cql.g3:42:7: qscope q= cqlquery
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_qscope_in_cqlquery104);
                    qscope1=qscope();
                    _fsp--;

                    pushFollow(FOLLOW_cqlquery_in_cqlquery109);
                    q=cqlquery();
                    _fsp--;

                    adaptor.addChild(root_0, q.getTree());
                     retval.query = q.query; 

                    }
                    break;
                case 2 :
                    // Cql.g3:43:7: c= scopedClause
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_scopedClause_in_cqlquery121);
                    c=scopedClause();
                    _fsp--;

                    adaptor.addChild(root_0, c.getTree());
                     retval.query = new CqlQuery(c.clause); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end cqlquery

    public static class qscope_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start qscope
    // Cql.g3:45:1: qscope : ( '>' prefix '=' uri | '>' uri );
    public final qscope_return qscope() throws RecognitionException {
        qscope_return retval = new qscope_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token char_literal2=null;
        Token char_literal4=null;
        Token char_literal6=null;
        prefix_return prefix3 = null;

        uri_return uri5 = null;

        uri_return uri7 = null;


        CommonTree char_literal2_tree=null;
        CommonTree char_literal4_tree=null;
        CommonTree char_literal6_tree=null;

        try {
            // Cql.g3:47:9: ( '>' prefix '=' uri | '>' uri )
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==16) ) {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA2_2 = input.LA(3);

                    if ( ((LA2_2>=AND && LA2_2<=PROX)||(LA2_2>=IDENTIFIER && LA2_2<=STRING)||LA2_2==16||LA2_2==19) ) {
                        alt2=2;
                    }
                    else if ( (LA2_2==17) ) {
                        alt2=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 2, input);

                        throw nvae;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA2_3 = input.LA(3);

                    if ( ((LA2_3>=AND && LA2_3<=PROX)||(LA2_3>=IDENTIFIER && LA2_3<=STRING)||LA2_3==16||LA2_3==19) ) {
                        alt2=2;
                    }
                    else if ( (LA2_3==17) ) {
                        alt2=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 3, input);

                        throw nvae;
                    }
                    }
                    break;
                case AND:
                    {
                    int LA2_4 = input.LA(3);

                    if ( (LA2_4==17) ) {
                        alt2=1;
                    }
                    else if ( ((LA2_4>=AND && LA2_4<=PROX)||(LA2_4>=IDENTIFIER && LA2_4<=STRING)||LA2_4==16||LA2_4==19) ) {
                        alt2=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 4, input);

                        throw nvae;
                    }
                    }
                    break;
                case OR:
                    {
                    int LA2_5 = input.LA(3);

                    if ( (LA2_5==17) ) {
                        alt2=1;
                    }
                    else if ( ((LA2_5>=AND && LA2_5<=PROX)||(LA2_5>=IDENTIFIER && LA2_5<=STRING)||LA2_5==16||LA2_5==19) ) {
                        alt2=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 5, input);

                        throw nvae;
                    }
                    }
                    break;
                case NOT:
                    {
                    int LA2_6 = input.LA(3);

                    if ( (LA2_6==17) ) {
                        alt2=1;
                    }
                    else if ( ((LA2_6>=AND && LA2_6<=PROX)||(LA2_6>=IDENTIFIER && LA2_6<=STRING)||LA2_6==16||LA2_6==19) ) {
                        alt2=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 6, input);

                        throw nvae;
                    }
                    }
                    break;
                case PROX:
                    {
                    int LA2_7 = input.LA(3);

                    if ( (LA2_7==17) ) {
                        alt2=1;
                    }
                    else if ( ((LA2_7>=AND && LA2_7<=PROX)||(LA2_7>=IDENTIFIER && LA2_7<=STRING)||LA2_7==16||LA2_7==19) ) {
                        alt2=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 7, input);

                        throw nvae;
                    }
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 1, input);

                    throw nvae;
                }

            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("45:1: qscope : ( '>' prefix '=' uri | '>' uri );", 2, 0, input);

                throw nvae;
            }
            switch (alt2) {
                case 1 :
                    // Cql.g3:47:11: '>' prefix '=' uri
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal2=(Token)input.LT(1);
                    match(input,16,FOLLOW_16_in_qscope137); 
                    char_literal2_tree = (CommonTree)adaptor.create(char_literal2);
                    adaptor.addChild(root_0, char_literal2_tree);

                    pushFollow(FOLLOW_prefix_in_qscope139);
                    prefix3=prefix();
                    _fsp--;

                    adaptor.addChild(root_0, prefix3.getTree());
                    char_literal4=(Token)input.LT(1);
                    match(input,17,FOLLOW_17_in_qscope141); 
                    char_literal4_tree = (CommonTree)adaptor.create(char_literal4);
                    adaptor.addChild(root_0, char_literal4_tree);

                    pushFollow(FOLLOW_uri_in_qscope143);
                    uri5=uri();
                    _fsp--;

                    adaptor.addChild(root_0, uri5.getTree());

                    }
                    break;
                case 2 :
                    // Cql.g3:47:32: '>' uri
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal6=(Token)input.LT(1);
                    match(input,16,FOLLOW_16_in_qscope147); 
                    char_literal6_tree = (CommonTree)adaptor.create(char_literal6);
                    adaptor.addChild(root_0, char_literal6_tree);

                    pushFollow(FOLLOW_uri_in_qscope149);
                    uri7=uri();
                    _fsp--;

                    adaptor.addChild(root_0, uri7.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end qscope

    public static class prefix_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start prefix
    // Cql.g3:48:1: prefix : term ;
    public final prefix_return prefix() throws RecognitionException {
        prefix_return retval = new prefix_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return term8 = null;



        try {
            // Cql.g3:48:9: ( term )
            // Cql.g3:48:11: term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_prefix158);
            term8=term();
            _fsp--;

            adaptor.addChild(root_0, term8.getTree());

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end prefix

    public static class uri_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start uri
    // Cql.g3:49:1: uri : term ;
    public final uri_return uri() throws RecognitionException {
        uri_return retval = new uri_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return term9 = null;



        try {
            // Cql.g3:49:7: ( term )
            // Cql.g3:49:9: term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_uri168);
            term9=term();
            _fsp--;

            adaptor.addChild(root_0, term9.getTree());

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end uri

    public static class scopedClause_return extends ParserRuleReturnScope {
        public CqlClause clause;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start scopedClause
    // Cql.g3:50:1: scopedClause returns [CqlClause clause] : left= searchClause (op= booleanGroup right= searchClause )* ;
    public final scopedClause_return scopedClause() throws RecognitionException {
        scopedClause_return retval = new scopedClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        searchClause_return left = null;

        booleanGroup_return op = null;

        searchClause_return right = null;



        try {
            // Cql.g3:53:41: (left= searchClause (op= booleanGroup right= searchClause )* )
            // Cql.g3:54:3: left= searchClause (op= booleanGroup right= searchClause )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_searchClause_in_scopedClause188);
            left=searchClause();
            _fsp--;

            adaptor.addChild(root_0, left.getTree());
             retval.clause = left.clause; 
            // Cql.g3:55:3: (op= booleanGroup right= searchClause )*
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( ((LA3_0>=AND && LA3_0<=PROX)) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // Cql.g3:55:4: op= booleanGroup right= searchClause
            	    {
            	    pushFollow(FOLLOW_booleanGroup_in_scopedClause197);
            	    op=booleanGroup();
            	    _fsp--;

            	    root_0 = (CommonTree)adaptor.becomeRoot(op.getTree(), root_0);
            	    pushFollow(FOLLOW_searchClause_in_scopedClause202);
            	    right=searchClause();
            	    _fsp--;

            	    adaptor.addChild(root_0, right.getTree());
            	     retval.clause = new CqlBoolean(retval.clause, op.value, right.clause); 

            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end scopedClause

    public static class booleanGroup_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start booleanGroup
    // Cql.g3:60:1: booleanGroup returns [String value] : b= bool ( modifierList )? ;
    public final booleanGroup_return booleanGroup() throws RecognitionException {
        booleanGroup_return retval = new booleanGroup_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        bool_return b = null;

        modifierList_return modifierList10 = null;



        try {
            // Cql.g3:60:37: (b= bool ( modifierList )? )
            // Cql.g3:61:2: b= bool ( modifierList )?
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_bool_in_booleanGroup230);
            b=bool();
            _fsp--;

            adaptor.addChild(root_0, b.getTree());
            // Cql.g3:61:9: ( modifierList )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==18) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // Cql.g3:61:10: modifierList
                    {
                    pushFollow(FOLLOW_modifierList_in_booleanGroup233);
                    modifierList10=modifierList();
                    _fsp--;

                    adaptor.addChild(root_0, modifierList10.getTree());

                    }
                    break;

            }

             retval.value = b.value; 

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end booleanGroup

    public static class bool_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start bool
    // Cql.g3:62:1: bool returns [String value] : ( AND | OR | NOT | PROX );
    public final bool_return bool() throws RecognitionException {
        bool_return retval = new bool_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token AND11=null;
        Token OR12=null;
        Token NOT13=null;
        Token PROX14=null;

        CommonTree AND11_tree=null;
        CommonTree OR12_tree=null;
        CommonTree NOT13_tree=null;
        CommonTree PROX14_tree=null;

        try {
            // Cql.g3:63:2: ( AND | OR | NOT | PROX )
            int alt5=4;
            switch ( input.LA(1) ) {
            case AND:
                {
                alt5=1;
                }
                break;
            case OR:
                {
                alt5=2;
                }
                break;
            case NOT:
                {
                alt5=3;
                }
                break;
            case PROX:
                {
                alt5=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("62:1: bool returns [String value] : ( AND | OR | NOT | PROX );", 5, 0, input);

                throw nvae;
            }

            switch (alt5) {
                case 1 :
                    // Cql.g3:63:4: AND
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    AND11=(Token)input.LT(1);
                    match(input,AND,FOLLOW_AND_in_bool250); 
                    AND11_tree = (CommonTree)adaptor.create(AND11);
                    adaptor.addChild(root_0, AND11_tree);

                     retval.value = "and"; 

                    }
                    break;
                case 2 :
                    // Cql.g3:64:4: OR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    OR12=(Token)input.LT(1);
                    match(input,OR,FOLLOW_OR_in_bool257); 
                    OR12_tree = (CommonTree)adaptor.create(OR12);
                    adaptor.addChild(root_0, OR12_tree);

                     retval.value = "or"; 

                    }
                    break;
                case 3 :
                    // Cql.g3:65:4: NOT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    NOT13=(Token)input.LT(1);
                    match(input,NOT,FOLLOW_NOT_in_bool264); 
                    NOT13_tree = (CommonTree)adaptor.create(NOT13);
                    adaptor.addChild(root_0, NOT13_tree);

                     retval.value = "not"; 

                    }
                    break;
                case 4 :
                    // Cql.g3:66:4: PROX
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    PROX14=(Token)input.LT(1);
                    match(input,PROX,FOLLOW_PROX_in_bool271); 
                    PROX14_tree = (CommonTree)adaptor.create(PROX14);
                    adaptor.addChild(root_0, PROX14_tree);

                     retval.value = "prox"; 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end bool

    public static class modifierList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start modifierList
    // Cql.g3:68:1: modifierList : ( modifier )+ ;
    public final modifierList_return modifierList() throws RecognitionException {
        modifierList_return retval = new modifierList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        modifier_return modifier15 = null;



        try {
            // Cql.g3:70:14: ( ( modifier )+ )
            // Cql.g3:70:16: ( modifier )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // Cql.g3:70:16: ( modifier )+
            int cnt6=0;
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( (LA6_0==18) ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // Cql.g3:70:17: modifier
            	    {
            	    pushFollow(FOLLOW_modifier_in_modifierList287);
            	    modifier15=modifier();
            	    _fsp--;

            	    adaptor.addChild(root_0, modifier15.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt6 >= 1 ) break loop6;
                        EarlyExitException eee =
                            new EarlyExitException(6, input);
                        throw eee;
                }
                cnt6++;
            } while (true);


            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end modifierList

    public static class modifier_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start modifier
    // Cql.g3:71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );
    public final modifier_return modifier() throws RecognitionException {
        modifier_return retval = new modifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token char_literal16=null;
        Token char_literal20=null;
        modifierName_return modifierName17 = null;

        comparitorSymbol_return comparitorSymbol18 = null;

        modifierValue_return modifierValue19 = null;

        modifierName_return modifierName21 = null;


        CommonTree char_literal16_tree=null;
        CommonTree char_literal20_tree=null;

        try {
            // Cql.g3:71:11: ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName )
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==18) ) {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA7_2 = input.LA(3);

                    if ( ((LA7_2>=AND && LA7_2<=PROX)||(LA7_2>=IDENTIFIER && LA7_2<=STRING)||(LA7_2>=18 && LA7_2<=19)) ) {
                        alt7=2;
                    }
                    else if ( ((LA7_2>=16 && LA7_2<=17)||(LA7_2>=21 && LA7_2<=24)) ) {
                        alt7=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 2, input);

                        throw nvae;
                    }
                    }
                    break;
                case STRING:
                    {
                    int LA7_3 = input.LA(3);

                    if ( ((LA7_3>=AND && LA7_3<=PROX)||(LA7_3>=IDENTIFIER && LA7_3<=STRING)||(LA7_3>=18 && LA7_3<=19)) ) {
                        alt7=2;
                    }
                    else if ( ((LA7_3>=16 && LA7_3<=17)||(LA7_3>=21 && LA7_3<=24)) ) {
                        alt7=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 3, input);

                        throw nvae;
                    }
                    }
                    break;
                case AND:
                    {
                    int LA7_4 = input.LA(3);

                    if ( ((LA7_4>=16 && LA7_4<=17)||(LA7_4>=21 && LA7_4<=24)) ) {
                        alt7=1;
                    }
                    else if ( ((LA7_4>=AND && LA7_4<=PROX)||(LA7_4>=IDENTIFIER && LA7_4<=STRING)||(LA7_4>=18 && LA7_4<=19)) ) {
                        alt7=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 4, input);

                        throw nvae;
                    }
                    }
                    break;
                case OR:
                    {
                    int LA7_5 = input.LA(3);

                    if ( ((LA7_5>=16 && LA7_5<=17)||(LA7_5>=21 && LA7_5<=24)) ) {
                        alt7=1;
                    }
                    else if ( ((LA7_5>=AND && LA7_5<=PROX)||(LA7_5>=IDENTIFIER && LA7_5<=STRING)||(LA7_5>=18 && LA7_5<=19)) ) {
                        alt7=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 5, input);

                        throw nvae;
                    }
                    }
                    break;
                case NOT:
                    {
                    int LA7_6 = input.LA(3);

                    if ( ((LA7_6>=16 && LA7_6<=17)||(LA7_6>=21 && LA7_6<=24)) ) {
                        alt7=1;
                    }
                    else if ( ((LA7_6>=AND && LA7_6<=PROX)||(LA7_6>=IDENTIFIER && LA7_6<=STRING)||(LA7_6>=18 && LA7_6<=19)) ) {
                        alt7=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 6, input);

                        throw nvae;
                    }
                    }
                    break;
                case PROX:
                    {
                    int LA7_7 = input.LA(3);

                    if ( ((LA7_7>=16 && LA7_7<=17)||(LA7_7>=21 && LA7_7<=24)) ) {
                        alt7=1;
                    }
                    else if ( ((LA7_7>=AND && LA7_7<=PROX)||(LA7_7>=IDENTIFIER && LA7_7<=STRING)||(LA7_7>=18 && LA7_7<=19)) ) {
                        alt7=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 7, input);

                        throw nvae;
                    }
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 1, input);

                    throw nvae;
                }

            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("71:1: modifier : ( '/' modifierName comparitorSymbol modifierValue | '/' modifierName );", 7, 0, input);

                throw nvae;
            }
            switch (alt7) {
                case 1 :
                    // Cql.g3:71:13: '/' modifierName comparitorSymbol modifierValue
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal16=(Token)input.LT(1);
                    match(input,18,FOLLOW_18_in_modifier298); 
                    char_literal16_tree = (CommonTree)adaptor.create(char_literal16);
                    adaptor.addChild(root_0, char_literal16_tree);

                    pushFollow(FOLLOW_modifierName_in_modifier300);
                    modifierName17=modifierName();
                    _fsp--;

                    adaptor.addChild(root_0, modifierName17.getTree());
                    pushFollow(FOLLOW_comparitorSymbol_in_modifier302);
                    comparitorSymbol18=comparitorSymbol();
                    _fsp--;

                    adaptor.addChild(root_0, comparitorSymbol18.getTree());
                    pushFollow(FOLLOW_modifierValue_in_modifier304);
                    modifierValue19=modifierValue();
                    _fsp--;

                    adaptor.addChild(root_0, modifierValue19.getTree());

                    }
                    break;
                case 2 :
                    // Cql.g3:72:9: '/' modifierName
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal20=(Token)input.LT(1);
                    match(input,18,FOLLOW_18_in_modifier314); 
                    char_literal20_tree = (CommonTree)adaptor.create(char_literal20);
                    adaptor.addChild(root_0, char_literal20_tree);

                    pushFollow(FOLLOW_modifierName_in_modifier316);
                    modifierName21=modifierName();
                    _fsp--;

                    adaptor.addChild(root_0, modifierName21.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end modifier

    public static class modifierName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start modifierName
    // Cql.g3:73:1: modifierName : term ;
    public final modifierName_return modifierName() throws RecognitionException {
        modifierName_return retval = new modifierName_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return term22 = null;



        try {
            // Cql.g3:73:14: ( term )
            // Cql.g3:73:16: term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_modifierName324);
            term22=term();
            _fsp--;

            adaptor.addChild(root_0, term22.getTree());

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end modifierName

    public static class modifierValue_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start modifierValue
    // Cql.g3:74:1: modifierValue : term ;
    public final modifierValue_return modifierValue() throws RecognitionException {
        modifierValue_return retval = new modifierValue_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return term23 = null;



        try {
            // Cql.g3:74:15: ( term )
            // Cql.g3:74:17: term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_modifierValue332);
            term23=term();
            _fsp--;

            adaptor.addChild(root_0, term23.getTree());

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end modifierValue

    public static class searchClause_return extends ParserRuleReturnScope {
        public CqlClause clause;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start searchClause
    // Cql.g3:75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );
    public final searchClause_return searchClause() throws RecognitionException {
        searchClause_return retval = new searchClause_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token char_literal24=null;
        Token char_literal25=null;
        cqlquery_return q = null;

        index_return i = null;

        relation_return r = null;

        searchTerm_return v = null;

        searchTerm_return t = null;


        CommonTree char_literal24_tree=null;
        CommonTree char_literal25_tree=null;

        try {
            // Cql.g3:79:6: ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm )
            int alt8=3;
            switch ( input.LA(1) ) {
            case 19:
                {
                alt8=1;
                }
                break;
            case IDENTIFIER:
                {
                int LA8_2 = input.LA(2);

                if ( ((LA8_2>=WITHIN && LA8_2<=ANY)||(LA8_2>=16 && LA8_2<=17)||(LA8_2>=21 && LA8_2<=24)) ) {
                    alt8=2;
                }
                else if ( (LA8_2==EOF||(LA8_2>=AND && LA8_2<=PROX)||LA8_2==20) ) {
                    alt8=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 2, input);

                    throw nvae;
                }
                }
                break;
            case STRING:
                {
                int LA8_3 = input.LA(2);

                if ( ((LA8_3>=WITHIN && LA8_3<=ANY)||(LA8_3>=16 && LA8_3<=17)||(LA8_3>=21 && LA8_3<=24)) ) {
                    alt8=2;
                }
                else if ( (LA8_3==EOF||(LA8_3>=AND && LA8_3<=PROX)||LA8_3==20) ) {
                    alt8=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 3, input);

                    throw nvae;
                }
                }
                break;
            case AND:
                {
                int LA8_4 = input.LA(2);

                if ( (LA8_4==EOF||(LA8_4>=AND && LA8_4<=PROX)||LA8_4==20) ) {
                    alt8=3;
                }
                else if ( ((LA8_4>=WITHIN && LA8_4<=ANY)||(LA8_4>=16 && LA8_4<=17)||(LA8_4>=21 && LA8_4<=24)) ) {
                    alt8=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 4, input);

                    throw nvae;
                }
                }
                break;
            case OR:
                {
                int LA8_5 = input.LA(2);

                if ( (LA8_5==EOF||(LA8_5>=AND && LA8_5<=PROX)||LA8_5==20) ) {
                    alt8=3;
                }
                else if ( ((LA8_5>=WITHIN && LA8_5<=ANY)||(LA8_5>=16 && LA8_5<=17)||(LA8_5>=21 && LA8_5<=24)) ) {
                    alt8=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 5, input);

                    throw nvae;
                }
                }
                break;
            case NOT:
                {
                int LA8_6 = input.LA(2);

                if ( (LA8_6==EOF||(LA8_6>=AND && LA8_6<=PROX)||LA8_6==20) ) {
                    alt8=3;
                }
                else if ( ((LA8_6>=WITHIN && LA8_6<=ANY)||(LA8_6>=16 && LA8_6<=17)||(LA8_6>=21 && LA8_6<=24)) ) {
                    alt8=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 6, input);

                    throw nvae;
                }
                }
                break;
            case PROX:
                {
                int LA8_7 = input.LA(2);

                if ( (LA8_7==EOF||(LA8_7>=AND && LA8_7<=PROX)||LA8_7==20) ) {
                    alt8=3;
                }
                else if ( ((LA8_7>=WITHIN && LA8_7<=ANY)||(LA8_7>=16 && LA8_7<=17)||(LA8_7>=21 && LA8_7<=24)) ) {
                    alt8=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 7, input);

                    throw nvae;
                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("75:1: searchClause returns [CqlClause clause] : ( '(' q= cqlquery ')' | i= index r= relation v= searchTerm | t= searchTerm );", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // Cql.g3:79:8: '(' q= cqlquery ')'
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal24=(Token)input.LT(1);
                    match(input,19,FOLLOW_19_in_searchClause353); 
                    pushFollow(FOLLOW_cqlquery_in_searchClause358);
                    q=cqlquery();
                    _fsp--;

                    adaptor.addChild(root_0, q.getTree());
                    char_literal25=(Token)input.LT(1);
                    match(input,20,FOLLOW_20_in_searchClause360); 
                     retval.clause = q.query.root; 

                    }
                    break;
                case 2 :
                    // Cql.g3:80:8: i= index r= relation v= searchTerm
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_index_in_searchClause374);
                    i=index();
                    _fsp--;

                    adaptor.addChild(root_0, i.getTree());
                    pushFollow(FOLLOW_relation_in_searchClause378);
                    r=relation();
                    _fsp--;

                    root_0 = (CommonTree)adaptor.becomeRoot(r.getTree(), root_0);
                    pushFollow(FOLLOW_searchTerm_in_searchClause383);
                    v=searchTerm();
                    _fsp--;

                    adaptor.addChild(root_0, v.getTree());
                     retval.clause = new CqlRelation(i.value, r.value, v.value); 

                    }
                    break;
                case 3 :
                    // Cql.g3:82:8: t= searchTerm
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_searchTerm_in_searchClause402);
                    t=searchTerm();
                    _fsp--;

                    adaptor.addChild(root_0, t.getTree());
                     retval.clause = new CqlTerm(t.value); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end searchClause

    public static class index_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start index
    // Cql.g3:84:1: index returns [String value] : t= term ;
    public final index_return index() throws RecognitionException {
        index_return retval = new index_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return t = null;



        try {
            // Cql.g3:84:31: (t= term )
            // Cql.g3:84:33: t= term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_index420);
            t=term();
            _fsp--;

            adaptor.addChild(root_0, t.getTree());
             retval.value = t.value; 

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end index

    public static class relation_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start relation
    // Cql.g3:86:1: relation returns [String value] : c= comparitor ( modifierList )? ;
    public final relation_return relation() throws RecognitionException {
        relation_return retval = new relation_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        comparitor_return c = null;

        modifierList_return modifierList26 = null;



        try {
            // Cql.g3:86:33: (c= comparitor ( modifierList )? )
            // Cql.g3:87:7: c= comparitor ( modifierList )?
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_comparitor_in_relation444);
            c=comparitor();
            _fsp--;

            adaptor.addChild(root_0, c.getTree());
             retval.value = c.value; 
            // Cql.g3:87:42: ( modifierList )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==18) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // Cql.g3:87:43: modifierList
                    {
                    pushFollow(FOLLOW_modifierList_in_relation449);
                    modifierList26=modifierList();
                    _fsp--;

                    adaptor.addChild(root_0, modifierList26.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end relation

    public static class comparitor_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start comparitor
    // Cql.g3:88:1: comparitor returns [String value] : (s= comparitorSymbol | n= namedComparitor );
    public final comparitor_return comparitor() throws RecognitionException {
        comparitor_return retval = new comparitor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        comparitorSymbol_return s = null;

        namedComparitor_return n = null;



        try {
            // Cql.g3:89:5: (s= comparitorSymbol | n= namedComparitor )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( ((LA10_0>=16 && LA10_0<=17)||(LA10_0>=21 && LA10_0<=24)) ) {
                alt10=1;
            }
            else if ( ((LA10_0>=WITHIN && LA10_0<=ANY)) ) {
                alt10=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("88:1: comparitor returns [String value] : (s= comparitorSymbol | n= namedComparitor );", 10, 0, input);

                throw nvae;
            }
            switch (alt10) {
                case 1 :
                    // Cql.g3:89:7: s= comparitorSymbol
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_comparitorSymbol_in_comparitor469);
                    s=comparitorSymbol();
                    _fsp--;

                    adaptor.addChild(root_0, s.getTree());
                     retval.value = s.value; 

                    }
                    break;
                case 2 :
                    // Cql.g3:90:7: n= namedComparitor
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_namedComparitor_in_comparitor481);
                    n=namedComparitor();
                    _fsp--;

                    adaptor.addChild(root_0, n.getTree());
                     retval.value = n.value; 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end comparitor

    public static class comparitorSymbol_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start comparitorSymbol
    // Cql.g3:91:1: comparitorSymbol returns [String value] : ( '=' | '>' | '<' | '>=' | '<=' | '<>' );
    public final comparitorSymbol_return comparitorSymbol() throws RecognitionException {
        comparitorSymbol_return retval = new comparitorSymbol_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token char_literal27=null;
        Token char_literal28=null;
        Token char_literal29=null;
        Token string_literal30=null;
        Token string_literal31=null;
        Token string_literal32=null;

        CommonTree char_literal27_tree=null;
        CommonTree char_literal28_tree=null;
        CommonTree char_literal29_tree=null;
        CommonTree string_literal30_tree=null;
        CommonTree string_literal31_tree=null;
        CommonTree string_literal32_tree=null;

        try {
            // Cql.g3:92:7: ( '=' | '>' | '<' | '>=' | '<=' | '<>' )
            int alt11=6;
            switch ( input.LA(1) ) {
            case 17:
                {
                alt11=1;
                }
                break;
            case 16:
                {
                alt11=2;
                }
                break;
            case 21:
                {
                alt11=3;
                }
                break;
            case 22:
                {
                alt11=4;
                }
                break;
            case 23:
                {
                alt11=5;
                }
                break;
            case 24:
                {
                alt11=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("91:1: comparitorSymbol returns [String value] : ( '=' | '>' | '<' | '>=' | '<=' | '<>' );", 11, 0, input);

                throw nvae;
            }

            switch (alt11) {
                case 1 :
                    // Cql.g3:92:9: '='
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal27=(Token)input.LT(1);
                    match(input,17,FOLLOW_17_in_comparitorSymbol501); 
                    char_literal27_tree = (CommonTree)adaptor.create(char_literal27);
                    adaptor.addChild(root_0, char_literal27_tree);

                     retval.value = "="; 

                    }
                    break;
                case 2 :
                    // Cql.g3:93:9: '>'
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal28=(Token)input.LT(1);
                    match(input,16,FOLLOW_16_in_comparitorSymbol513); 
                    char_literal28_tree = (CommonTree)adaptor.create(char_literal28);
                    adaptor.addChild(root_0, char_literal28_tree);

                     retval.value = ">"; 

                    }
                    break;
                case 3 :
                    // Cql.g3:94:9: '<'
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    char_literal29=(Token)input.LT(1);
                    match(input,21,FOLLOW_21_in_comparitorSymbol525); 
                    char_literal29_tree = (CommonTree)adaptor.create(char_literal29);
                    adaptor.addChild(root_0, char_literal29_tree);

                     retval.value = "<"; 

                    }
                    break;
                case 4 :
                    // Cql.g3:95:9: '>='
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    string_literal30=(Token)input.LT(1);
                    match(input,22,FOLLOW_22_in_comparitorSymbol537); 
                    string_literal30_tree = (CommonTree)adaptor.create(string_literal30);
                    adaptor.addChild(root_0, string_literal30_tree);

                     retval.value = ">="; 

                    }
                    break;
                case 5 :
                    // Cql.g3:96:9: '<='
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    string_literal31=(Token)input.LT(1);
                    match(input,23,FOLLOW_23_in_comparitorSymbol549); 
                    string_literal31_tree = (CommonTree)adaptor.create(string_literal31);
                    adaptor.addChild(root_0, string_literal31_tree);

                     retval.value = "<="; 

                    }
                    break;
                case 6 :
                    // Cql.g3:97:9: '<>'
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    string_literal32=(Token)input.LT(1);
                    match(input,24,FOLLOW_24_in_comparitorSymbol561); 
                    string_literal32_tree = (CommonTree)adaptor.create(string_literal32);
                    adaptor.addChild(root_0, string_literal32_tree);

                     retval.value = "<>"; 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end comparitorSymbol

    public static class namedComparitor_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start namedComparitor
    // Cql.g3:99:1: namedComparitor returns [String value] : ( WITHIN | EXACT | ALL | ANY );
    public final namedComparitor_return namedComparitor() throws RecognitionException {
        namedComparitor_return retval = new namedComparitor_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token WITHIN33=null;
        Token EXACT34=null;
        Token ALL35=null;
        Token ANY36=null;

        CommonTree WITHIN33_tree=null;
        CommonTree EXACT34_tree=null;
        CommonTree ALL35_tree=null;
        CommonTree ANY36_tree=null;

        try {
            // Cql.g3:100:5: ( WITHIN | EXACT | ALL | ANY )
            int alt12=4;
            switch ( input.LA(1) ) {
            case WITHIN:
                {
                alt12=1;
                }
                break;
            case EXACT:
                {
                alt12=2;
                }
                break;
            case ALL:
                {
                alt12=3;
                }
                break;
            case ANY:
                {
                alt12=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("99:1: namedComparitor returns [String value] : ( WITHIN | EXACT | ALL | ANY );", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // Cql.g3:100:7: WITHIN
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    WITHIN33=(Token)input.LT(1);
                    match(input,WITHIN,FOLLOW_WITHIN_in_namedComparitor582); 
                    WITHIN33_tree = (CommonTree)adaptor.create(WITHIN33);
                    adaptor.addChild(root_0, WITHIN33_tree);

                     retval.value = "within"; 

                    }
                    break;
                case 2 :
                    // Cql.g3:101:7: EXACT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    EXACT34=(Token)input.LT(1);
                    match(input,EXACT,FOLLOW_EXACT_in_namedComparitor593); 
                    EXACT34_tree = (CommonTree)adaptor.create(EXACT34);
                    adaptor.addChild(root_0, EXACT34_tree);

                     retval.value = "exact"; 

                    }
                    break;
                case 3 :
                    // Cql.g3:102:7: ALL
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ALL35=(Token)input.LT(1);
                    match(input,ALL,FOLLOW_ALL_in_namedComparitor604); 
                    ALL35_tree = (CommonTree)adaptor.create(ALL35);
                    adaptor.addChild(root_0, ALL35_tree);

                     retval.value = "all"; 

                    }
                    break;
                case 4 :
                    // Cql.g3:103:7: ANY
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ANY36=(Token)input.LT(1);
                    match(input,ANY,FOLLOW_ANY_in_namedComparitor614); 
                    ANY36_tree = (CommonTree)adaptor.create(ANY36);
                    adaptor.addChild(root_0, ANY36_tree);

                     retval.value = "any"; 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end namedComparitor

    public static class searchTerm_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start searchTerm
    // Cql.g3:106:1: searchTerm returns [String value] : t= term ;
    public final searchTerm_return searchTerm() throws RecognitionException {
        searchTerm_return retval = new searchTerm_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        term_return t = null;



        try {
            // Cql.g3:106:36: (t= term )
            // Cql.g3:106:38: t= term
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_term_in_searchTerm633);
            t=term();
            _fsp--;

            adaptor.addChild(root_0, t.getTree());
             retval.value = t.value; 

            }

            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end searchTerm

    public static class term_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start term
    // Cql.g3:108:1: term returns [String value] : (i= identifier | AND | OR | NOT | PROX );
    public final term_return term() throws RecognitionException {
        term_return retval = new term_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token AND37=null;
        Token OR38=null;
        Token NOT39=null;
        Token PROX40=null;
        identifier_return i = null;


        CommonTree AND37_tree=null;
        CommonTree OR38_tree=null;
        CommonTree NOT39_tree=null;
        CommonTree PROX40_tree=null;

        try {
            // Cql.g3:108:30: (i= identifier | AND | OR | NOT | PROX )
            int alt13=5;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
            case STRING:
                {
                alt13=1;
                }
                break;
            case AND:
                {
                alt13=2;
                }
                break;
            case OR:
                {
                alt13=3;
                }
                break;
            case NOT:
                {
                alt13=4;
                }
                break;
            case PROX:
                {
                alt13=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("108:1: term returns [String value] : (i= identifier | AND | OR | NOT | PROX );", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // Cql.g3:109:5: i= identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_identifier_in_term655);
                    i=identifier();
                    _fsp--;

                    adaptor.addChild(root_0, i.getTree());
                     retval.value = i.value; 

                    }
                    break;
                case 2 :
                    // Cql.g3:110:7: AND
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    AND37=(Token)input.LT(1);
                    match(input,AND,FOLLOW_AND_in_term665); 
                    AND37_tree = (CommonTree)adaptor.create(AND37);
                    adaptor.addChild(root_0, AND37_tree);

                     retval.value = "and"; 

                    }
                    break;
                case 3 :
                    // Cql.g3:111:7: OR
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    OR38=(Token)input.LT(1);
                    match(input,OR,FOLLOW_OR_in_term675); 
                    OR38_tree = (CommonTree)adaptor.create(OR38);
                    adaptor.addChild(root_0, OR38_tree);

                     retval.value = "or"; 

                    }
                    break;
                case 4 :
                    // Cql.g3:112:7: NOT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    NOT39=(Token)input.LT(1);
                    match(input,NOT,FOLLOW_NOT_in_term685); 
                    NOT39_tree = (CommonTree)adaptor.create(NOT39);
                    adaptor.addChild(root_0, NOT39_tree);

                     retval.value = "not"; 

                    }
                    break;
                case 5 :
                    // Cql.g3:113:7: PROX
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    PROX40=(Token)input.LT(1);
                    match(input,PROX,FOLLOW_PROX_in_term695); 
                    PROX40_tree = (CommonTree)adaptor.create(PROX40);
                    adaptor.addChild(root_0, PROX40_tree);

                     retval.value = "prox"; 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end term

    public static class identifier_return extends ParserRuleReturnScope {
        public String value;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start identifier
    // Cql.g3:114:1: identifier returns [String value] : ( IDENTIFIER | STRING );
    public final identifier_return identifier() throws RecognitionException {
        identifier_return retval = new identifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token IDENTIFIER41=null;
        Token STRING42=null;

        CommonTree IDENTIFIER41_tree=null;
        CommonTree STRING42_tree=null;

        try {
            // Cql.g3:114:35: ( IDENTIFIER | STRING )
            int alt14=2;
            int LA14_0 = input.LA(1);

            if ( (LA14_0==IDENTIFIER) ) {
                alt14=1;
            }
            else if ( (LA14_0==STRING) ) {
                alt14=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("114:1: identifier returns [String value] : ( IDENTIFIER | STRING );", 14, 0, input);

                throw nvae;
            }
            switch (alt14) {
                case 1 :
                    // Cql.g3:115:5: IDENTIFIER
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    IDENTIFIER41=(Token)input.LT(1);
                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_identifier713); 
                    IDENTIFIER41_tree = (CommonTree)adaptor.create(IDENTIFIER41);
                    adaptor.addChild(root_0, IDENTIFIER41_tree);

                     retval.value = IDENTIFIER41.getText(); 

                    }
                    break;
                case 2 :
                    // Cql.g3:116:7: STRING
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    STRING42=(Token)input.LT(1);
                    match(input,STRING,FOLLOW_STRING_in_identifier723); 
                    STRING42_tree = (CommonTree)adaptor.create(STRING42);
                    adaptor.addChild(root_0, STRING42_tree);

                     retval.value = STRING42.getText(); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

                retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end identifier


 

    public static final BitSet FOLLOW_cqlquery_in_cql78 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_qscope_in_cqlquery104 = new BitSet(new long[]{0x00000000000930F0L});
    public static final BitSet FOLLOW_cqlquery_in_cqlquery109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_scopedClause_in_cqlquery121 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_16_in_qscope137 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_prefix_in_qscope139 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_17_in_qscope141 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_uri_in_qscope143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_16_in_qscope147 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_uri_in_qscope149 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_prefix158 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_uri168 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause188 = new BitSet(new long[]{0x00000000000000F2L});
    public static final BitSet FOLLOW_booleanGroup_in_scopedClause197 = new BitSet(new long[]{0x00000000000830F0L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause202 = new BitSet(new long[]{0x00000000000000F2L});
    public static final BitSet FOLLOW_bool_in_booleanGroup230 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_modifierList_in_booleanGroup233 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AND_in_bool250 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OR_in_bool257 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_bool264 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROX_in_bool271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modifier_in_modifierList287 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_18_in_modifier298 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_modifierName_in_modifier300 = new BitSet(new long[]{0x0000000001E30000L});
    public static final BitSet FOLLOW_comparitorSymbol_in_modifier302 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_modifierValue_in_modifier304 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_18_in_modifier314 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_modifierName_in_modifier316 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_modifierName324 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_modifierValue332 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_19_in_searchClause353 = new BitSet(new long[]{0x00000000000930F0L});
    public static final BitSet FOLLOW_cqlquery_in_searchClause358 = new BitSet(new long[]{0x0000000000100000L});
    public static final BitSet FOLLOW_20_in_searchClause360 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_index_in_searchClause374 = new BitSet(new long[]{0x0000000001E30F00L});
    public static final BitSet FOLLOW_relation_in_searchClause378 = new BitSet(new long[]{0x00000000000030F0L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause383 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause402 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_index420 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_comparitor_in_relation444 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_modifierList_in_relation449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_comparitorSymbol_in_comparitor469 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_namedComparitor_in_comparitor481 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_comparitorSymbol501 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_16_in_comparitorSymbol513 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_21_in_comparitorSymbol525 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_22_in_comparitorSymbol537 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_23_in_comparitorSymbol549 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_comparitorSymbol561 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WITHIN_in_namedComparitor582 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXACT_in_namedComparitor593 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ALL_in_namedComparitor604 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ANY_in_namedComparitor614 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_searchTerm633 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_term655 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AND_in_term665 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OR_in_term675 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_term685 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROX_in_term695 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_identifier713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_identifier723 = new BitSet(new long[]{0x0000000000000002L});

}