/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.utils.sql;

import eu.dnetlib.utils.sql.ConnectionFactoryException;
import java.sql.Connection;
import java.sql.DriverManager;

public class ConnectionFactory {
    private String driver;
    private String url;
    private Connection connection;

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void init() throws ConnectionFactoryException {
        try {
            Class.forName(this.driver).newInstance();
            this.connection = DriverManager.getConnection(this.url);
        }
        catch (Exception e) {
            throw new ConnectionFactoryException("error connecting to " + this.url + " using JDBC driver " + this.driver, e);
        }
    }

    public void destroy() throws ConnectionFactoryException {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            throw new ConnectionFactoryException("error closing connection", e);
        }
    }
}

