/**
 * 
 */
package eu.dnetlib.utils.cql;

/**
 * @author stoumpos
 * 
 */
public class CqlRelation extends CqlClause {

	String index = null;
	String operator = null;
	String value = null;

	public CqlRelation() {
		this(null, null, null);
	}

	public CqlRelation(String index, String operator, String value) {
		super(CqlClauseType.RELATION);
		this.index = index;
		this.operator = operator;
		this.value = value;
	}

	public String getIndex() {
		return index;
	}

	public void setIndex(String index) {
		this.index = index;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public String toCqlString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(index).append(" ").append(operator);
		buffer.append(" ").append(value);
		return buffer.toString();
	}

	@Override
	public String toNodeString(String prefix) {
		return prefix + "relation: " + toCqlString();
	}
}
