/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
public class MainApplication {
    @Value(value="${oai.conf.app.public_url}")
    private String swaggerPublicUrl;
    @Value(value="${oai.conf.app.main_title}")
    private String swaggerMainTitle;
    @Value(value="${oai.conf.app.api_title}")
    private String swaggerApiTitle;
    @Value(value="${oai.conf.app.api_desc}")
    private String swaggerApiDesc;
    @Value(value="${oai.conf.app.api_version}")
    private String swaggerApiVersion;
    private static final License AGPL_3_LICENSE = new License().name("GNU Affero General Public License v3.0 or later").url("https://www.gnu.org/licenses/agpl-3.0.txt");

    public static void main(String[] args) {
        SpringApplication.run(MainApplication.class, (String[])args);
    }

    @Bean
    public OpenAPI newSwaggerDocket() {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (StringUtils.isNotBlank((CharSequence)this.swaggerPublicUrl)) {
            Server server = new Server();
            server.setUrl(this.swaggerPublicUrl);
            server.setDescription(this.swaggerMainTitle);
            servers.add(server);
        }
        return new OpenAPI().servers(servers).info(this.getSwaggerInfo()).tags(this.swaggerTags());
    }

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group(this.swaggerApiTitle).pathsToMatch(new String[]{"/api/**"}).build();
    }

    private Info getSwaggerInfo() {
        return new Info().title(this.swaggerApiTitle).description(this.swaggerApiDesc).version(this.swaggerApiVersion).license(AGPL_3_LICENSE);
    }

    protected List<Tag> swaggerTags() {
        return new ArrayList<Tag>();
    }
}

