/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.apps.oai.storage;

import eu.dnetlib.apps.oai.storage.StorageClient;
import eu.dnetlib.apps.oai.utils.SimpleUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpStorage
extends StorageClient {
    private static final Log log = LogFactory.getLog(FtpStorage.class);
    private final FTPClient ftp;
    private long currentPage = -1L;

    public FtpStorage(String jobId, URI storageBasePath, String ftpUser, String ftpPassword) {
        super(jobId, storageBasePath);
        String protocol = storageBasePath.getScheme();
        String host = storageBasePath.getHost();
        int port = storageBasePath.getPort();
        this.ftp = this.ftpConnect(host, port, protocol.equalsIgnoreCase("ftps"));
        this.ftpLogin(ftpUser, ftpPassword);
        this.changeDir(storageBasePath.getPath());
        this.changeDir(jobId);
    }

    private FTPClient ftpConnect(String server, int port, boolean secure) {
        try {
            if (secure) {
                FTPSClient ftp = new FTPSClient();
                ftp.connect(server, port > 0 ? port : 990);
                ftp.execPBSZ(0L);
                ftp.execPROT("P");
                return ftp;
            }
            FTPClient ftp = new FTPClient();
            ftp.connect(server, port > 0 ? port : 21);
            return ftp;
        }
        catch (IOException e) {
            log.error((Object)"Ftp Connection Failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void ftpLogin(String user, String password) {
        try {
            if (!this.ftp.login(user, password)) {
                throw new RuntimeException("FTP login failed");
            }
            this.ftp.setFileType(2);
            this.ftp.enterLocalPassiveMode();
            this.ftp.setBufferSize(1024);
            log.info((Object)"Ftp logged");
        }
        catch (IOException e) {
            log.error((Object)"Ftp Login Failed", (Throwable)e);
            this.complete();
            throw new RuntimeException(e);
        }
    }

    public void complete() {
        if (this.ftp != null && this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
                log.info((Object)"Ftp Disconnected");
            }
            catch (IOException e) {
                log.error((Object)"Ftp Disconnection Failed");
                throw new RuntimeException(e);
            }
        }
    }

    public void prepareCurrentPage(long page) {
        if (page != this.currentPage) {
            this.currentPage = page;
            this.changeDir("..");
            this.changeDir(SimpleUtils.pageToDir((long)page));
        }
    }

    private boolean changeDir(String dir) {
        try {
            if (!this.ftp.changeWorkingDirectory(dir)) {
                this.ftp.makeDirectory(dir);
                return this.ftp.changeWorkingDirectory(dir);
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)("Error changing or create dir: " + dir));
            this.complete();
            throw new RuntimeException("Error changing or create dir: " + dir, e);
        }
    }

    public void saveFile(String filename, String content) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());){
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving file " + filename));
                log.debug((Object)content);
            }
            if (!this.ftp.storeFile(filename, (InputStream)is)) {
                log.error((Object)("Error saving file: " + this.ftp.getReplyCode() + " - " + this.ftp.getReplyString()));
                throw new RuntimeException("Error saving file: " + this.ftp.getReplyString());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error saving info file");
            throw new RuntimeException("Error saving info file", e);
        }
    }
}

